/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle149.jcajce.provider.symmetric;

import org.bouncycastle149.crypto.CipherKeyGenerator;
import org.bouncycastle149.crypto.engines.CAST6Engine;
import org.bouncycastle149.crypto.macs.GMac;
import org.bouncycastle149.crypto.modes.GCMBlockCipher;
import org.bouncycastle149.jcajce.provider.config.ConfigurableProvider;
import org.bouncycastle149.jcajce.provider.symmetric.SymmetricAlgorithmProvider;
import org.bouncycastle149.jcajce.provider.symmetric.util.BaseBlockCipher;
import org.bouncycastle149.jcajce.provider.symmetric.util.BaseKeyGenerator;
import org.bouncycastle149.jcajce.provider.symmetric.util.BaseMac;

public final class CAST6 {
    private CAST6() {
    }

    public static class ECB
    extends BaseBlockCipher {
        public ECB() {
            super(new CAST6Engine());
        }
    }

    public static class GMAC
    extends BaseMac {
        public GMAC() {
            super(new GMac(new GCMBlockCipher(new CAST6Engine())));
        }
    }

    public static class KeyGen
    extends BaseKeyGenerator {
        public KeyGen() {
            super("CAST6", 256, new CipherKeyGenerator());
        }
    }

    public static class Mappings
    extends SymmetricAlgorithmProvider {
        private static final String PREFIX = CAST6.class.getName();

        public void configure(ConfigurableProvider configurableProvider) {
            configurableProvider.addAlgorithm("Cipher.CAST6", PREFIX + "$ECB");
            configurableProvider.addAlgorithm("KeyGenerator.CAST6", PREFIX + "$KeyGen");
            this.addGMacAlgorithm(configurableProvider, "CAST6", PREFIX + "$GMAC", PREFIX + "$KeyGen");
        }
    }
}

