/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle149.jcajce.provider.symmetric;

import org.bouncycastle149.crypto.BlockCipher;
import org.bouncycastle149.crypto.CipherKeyGenerator;
import org.bouncycastle149.crypto.engines.TwofishEngine;
import org.bouncycastle149.crypto.macs.GMac;
import org.bouncycastle149.crypto.modes.CBCBlockCipher;
import org.bouncycastle149.crypto.modes.GCMBlockCipher;
import org.bouncycastle149.jcajce.provider.config.ConfigurableProvider;
import org.bouncycastle149.jcajce.provider.symmetric.SymmetricAlgorithmProvider;
import org.bouncycastle149.jcajce.provider.symmetric.util.BaseBlockCipher;
import org.bouncycastle149.jcajce.provider.symmetric.util.BaseKeyGenerator;
import org.bouncycastle149.jcajce.provider.symmetric.util.BaseMac;
import org.bouncycastle149.jcajce.provider.symmetric.util.BlockCipherProvider;
import org.bouncycastle149.jcajce.provider.symmetric.util.IvAlgorithmParameters;
import org.bouncycastle149.jcajce.provider.symmetric.util.PBESecretKeyFactory;

public final class Twofish {
    private Twofish() {
    }

    public static class AlgParams
    extends IvAlgorithmParameters {
        protected String engineToString() {
            return "Twofish IV";
        }
    }

    public static class ECB
    extends BaseBlockCipher {
        public ECB() {
            super(new BlockCipherProvider(){

                public BlockCipher get() {
                    return new TwofishEngine();
                }
            });
        }
    }

    public static class GMAC
    extends BaseMac {
        public GMAC() {
            super(new GMac(new GCMBlockCipher(new TwofishEngine())));
        }
    }

    public static class KeyGen
    extends BaseKeyGenerator {
        public KeyGen() {
            super("Twofish", 256, new CipherKeyGenerator());
        }
    }

    public static class Mappings
    extends SymmetricAlgorithmProvider {
        private static final String PREFIX = Twofish.class.getName();

        public void configure(ConfigurableProvider configurableProvider) {
            configurableProvider.addAlgorithm("Cipher.Twofish", PREFIX + "$ECB");
            configurableProvider.addAlgorithm("KeyGenerator.Twofish", PREFIX + "$KeyGen");
            configurableProvider.addAlgorithm("AlgorithmParameters.Twofish", PREFIX + "$AlgParams");
            configurableProvider.addAlgorithm("Alg.Alias.AlgorithmParameters.PBEWITHSHAANDTWOFISH", "PKCS12PBE");
            configurableProvider.addAlgorithm("Alg.Alias.AlgorithmParameters.PBEWITHSHAANDTWOFISH-CBC", "PKCS12PBE");
            configurableProvider.addAlgorithm("Cipher.PBEWITHSHAANDTWOFISH-CBC", PREFIX + "$PBEWithSHA");
            configurableProvider.addAlgorithm("SecretKeyFactory.PBEWITHSHAANDTWOFISH-CBC", PREFIX + "$PBEWithSHAKeyFactory");
            this.addGMacAlgorithm(configurableProvider, "Twofish", PREFIX + "$GMAC", PREFIX + "$KeyGen");
        }
    }

    public static class PBEWithSHA
    extends BaseBlockCipher {
        public PBEWithSHA() {
            super(new CBCBlockCipher(new TwofishEngine()));
        }
    }

    public static class PBEWithSHAKeyFactory
    extends PBESecretKeyFactory {
        public PBEWithSHAKeyFactory() {
            super("PBEwithSHAandTwofish-CBC", null, true, 2, 1, 256, 128);
        }
    }
}

