/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle149.openssl.jcajce;

import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import org.bouncycastle149.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle149.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle149.asn1.x9.X9ObjectIdentifiers;
import org.bouncycastle149.jcajce.DefaultJcaJceHelper;
import org.bouncycastle149.jcajce.JcaJceHelper;
import org.bouncycastle149.jcajce.NamedJcaJceHelper;
import org.bouncycastle149.jcajce.ProviderJcaJceHelper;
import org.bouncycastle149.openssl.PEMException;
import org.bouncycastle149.openssl.PEMKeyPair;

public class JcaPEMKeyConverter {
    private JcaJceHelper helper = new DefaultJcaJceHelper();

    public JcaPEMKeyConverter setProvider(Provider provider) {
        this.helper = new ProviderJcaJceHelper(provider);
        return this;
    }

    public JcaPEMKeyConverter setProvider(String string) {
        this.helper = new NamedJcaJceHelper(string);
        return this;
    }

    public KeyPair getKeyPair(PEMKeyPair pEMKeyPair) throws PEMException {
        try {
            String string = pEMKeyPair.getPrivateKeyInfo().getPrivateKeyAlgorithm().getAlgorithm().getId();
            if (X9ObjectIdentifiers.id_ecPublicKey.getId().equals(string)) {
                string = "ECDSA";
            }
            KeyFactory keyFactory = this.helper.createKeyFactory(string);
            return new KeyPair(keyFactory.generatePublic(new X509EncodedKeySpec(pEMKeyPair.getPublicKeyInfo().getEncoded())), keyFactory.generatePrivate(new PKCS8EncodedKeySpec(pEMKeyPair.getPrivateKeyInfo().getEncoded())));
        }
        catch (Exception exception) {
            throw new PEMException("unable to convert key pair: " + exception.getMessage(), exception);
        }
    }

    public PublicKey getPublicKey(SubjectPublicKeyInfo subjectPublicKeyInfo) throws PEMException {
        try {
            String string = subjectPublicKeyInfo.getAlgorithm().getAlgorithm().getId();
            if (X9ObjectIdentifiers.id_ecPublicKey.getId().equals(string)) {
                string = "ECDSA";
            }
            KeyFactory keyFactory = this.helper.createKeyFactory(string);
            return keyFactory.generatePublic(new X509EncodedKeySpec(subjectPublicKeyInfo.getEncoded()));
        }
        catch (Exception exception) {
            throw new PEMException("unable to convert key pair: " + exception.getMessage(), exception);
        }
    }

    public PrivateKey getPrivateKey(PrivateKeyInfo privateKeyInfo) throws PEMException {
        try {
            String string = privateKeyInfo.getPrivateKeyAlgorithm().getAlgorithm().getId();
            if (X9ObjectIdentifiers.id_ecPublicKey.getId().equals(string)) {
                string = "ECDSA";
            }
            KeyFactory keyFactory = this.helper.createKeyFactory(string);
            return keyFactory.generatePrivate(new PKCS8EncodedKeySpec(privateKeyInfo.getEncoded()));
        }
        catch (Exception exception) {
            throw new PEMException("unable to convert key pair: " + exception.getMessage(), exception);
        }
    }
}

