/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle149.openssl.jcajce;

import java.io.IOException;
import java.io.InputStream;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.Provider;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import org.bouncycastle149.asn1.pkcs.EncryptionScheme;
import org.bouncycastle149.asn1.pkcs.KeyDerivationFunc;
import org.bouncycastle149.asn1.pkcs.PBEParameter;
import org.bouncycastle149.asn1.pkcs.PBES2Parameters;
import org.bouncycastle149.asn1.pkcs.PBKDF2Params;
import org.bouncycastle149.asn1.pkcs.PKCS12PBEParams;
import org.bouncycastle149.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle149.jcajce.DefaultJcaJceHelper;
import org.bouncycastle149.jcajce.JcaJceHelper;
import org.bouncycastle149.jcajce.NamedJcaJceHelper;
import org.bouncycastle149.jcajce.ProviderJcaJceHelper;
import org.bouncycastle149.openssl.PEMException;
import org.bouncycastle149.openssl.jcajce.PEMUtilities;
import org.bouncycastle149.operator.InputDecryptor;
import org.bouncycastle149.operator.InputDecryptorProvider;
import org.bouncycastle149.operator.OperatorCreationException;

public class JceOpenSSLPKCS8DecryptorProviderBuilder {
    private JcaJceHelper helper = new DefaultJcaJceHelper();

    public JceOpenSSLPKCS8DecryptorProviderBuilder setProvider(String string) {
        this.helper = new NamedJcaJceHelper(string);
        return this;
    }

    public JceOpenSSLPKCS8DecryptorProviderBuilder setProvider(Provider provider) {
        this.helper = new ProviderJcaJceHelper(provider);
        return this;
    }

    public InputDecryptorProvider build(final char[] cArray) throws OperatorCreationException {
        return new InputDecryptorProvider(){

            public InputDecryptor get(final AlgorithmIdentifier algorithmIdentifier) throws OperatorCreationException {
                try {
                    Cipher cipher;
                    if (PEMUtilities.isPKCS5Scheme2(algorithmIdentifier.getAlgorithm())) {
                        PBES2Parameters pBES2Parameters = PBES2Parameters.getInstance(algorithmIdentifier.getParameters());
                        KeyDerivationFunc keyDerivationFunc = pBES2Parameters.getKeyDerivationFunc();
                        EncryptionScheme encryptionScheme = pBES2Parameters.getEncryptionScheme();
                        PBKDF2Params pBKDF2Params = (PBKDF2Params)keyDerivationFunc.getParameters();
                        int n = pBKDF2Params.getIterationCount().intValue();
                        byte[] byArray = pBKDF2Params.getSalt();
                        String string = encryptionScheme.getAlgorithm().getId();
                        SecretKey secretKey = PEMUtilities.generateSecretKeyForPKCS5Scheme2(string, cArray, byArray, n);
                        cipher = JceOpenSSLPKCS8DecryptorProviderBuilder.this.helper.createCipher(string);
                        AlgorithmParameters algorithmParameters = JceOpenSSLPKCS8DecryptorProviderBuilder.this.helper.createAlgorithmParameters(string);
                        algorithmParameters.init(encryptionScheme.getParameters().toASN1Primitive().getEncoded());
                        cipher.init(2, (Key)secretKey, algorithmParameters);
                    } else if (PEMUtilities.isPKCS12(algorithmIdentifier.getAlgorithm())) {
                        PKCS12PBEParams pKCS12PBEParams = PKCS12PBEParams.getInstance(algorithmIdentifier.getParameters());
                        PBEKeySpec pBEKeySpec = new PBEKeySpec(cArray);
                        SecretKeyFactory secretKeyFactory = JceOpenSSLPKCS8DecryptorProviderBuilder.this.helper.createSecretKeyFactory(algorithmIdentifier.getAlgorithm().getId());
                        PBEParameterSpec pBEParameterSpec = new PBEParameterSpec(pKCS12PBEParams.getIV(), pKCS12PBEParams.getIterations().intValue());
                        cipher = JceOpenSSLPKCS8DecryptorProviderBuilder.this.helper.createCipher(algorithmIdentifier.getAlgorithm().getId());
                        cipher.init(2, (Key)secretKeyFactory.generateSecret(pBEKeySpec), pBEParameterSpec);
                    } else if (PEMUtilities.isPKCS5Scheme1(algorithmIdentifier.getAlgorithm())) {
                        PBEParameter pBEParameter = PBEParameter.getInstance(algorithmIdentifier.getParameters());
                        PBEKeySpec pBEKeySpec = new PBEKeySpec(cArray);
                        SecretKeyFactory secretKeyFactory = JceOpenSSLPKCS8DecryptorProviderBuilder.this.helper.createSecretKeyFactory(algorithmIdentifier.getAlgorithm().getId());
                        PBEParameterSpec pBEParameterSpec = new PBEParameterSpec(pBEParameter.getSalt(), pBEParameter.getIterationCount().intValue());
                        cipher = JceOpenSSLPKCS8DecryptorProviderBuilder.this.helper.createCipher(algorithmIdentifier.getAlgorithm().getId());
                        cipher.init(2, (Key)secretKeyFactory.generateSecret(pBEKeySpec), pBEParameterSpec);
                    } else {
                        throw new PEMException("Unknown algorithm: " + algorithmIdentifier.getAlgorithm());
                    }
                    return new InputDecryptor(){

                        public AlgorithmIdentifier getAlgorithmIdentifier() {
                            return algorithmIdentifier;
                        }

                        public InputStream getInputStream(InputStream inputStream) {
                            return new CipherInputStream(inputStream, cipher);
                        }
                    };
                }
                catch (IOException iOException) {
                    throw new OperatorCreationException(algorithmIdentifier.getAlgorithm() + " not available: " + iOException.getMessage(), iOException);
                }
                catch (GeneralSecurityException generalSecurityException) {
                    throw new OperatorCreationException(algorithmIdentifier.getAlgorithm() + " not available: " + generalSecurityException.getMessage(), generalSecurityException);
                }
            }
        };
    }
}

