/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle149.operator.bc;

import java.io.OutputStream;
import java.security.SecureRandom;
import org.bouncycastle149.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle149.crypto.CryptoException;
import org.bouncycastle149.crypto.Signer;
import org.bouncycastle149.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle149.crypto.params.ParametersWithRandom;
import org.bouncycastle149.operator.ContentSigner;
import org.bouncycastle149.operator.OperatorCreationException;
import org.bouncycastle149.operator.RuntimeOperatorException;
import org.bouncycastle149.operator.bc.BcDefaultDigestProvider;
import org.bouncycastle149.operator.bc.BcDigestProvider;
import org.bouncycastle149.operator.bc.BcSignerOutputStream;

public abstract class BcContentSignerBuilder {
    private SecureRandom random;
    private AlgorithmIdentifier sigAlgId;
    private AlgorithmIdentifier digAlgId;
    protected BcDigestProvider digestProvider;

    public BcContentSignerBuilder(AlgorithmIdentifier algorithmIdentifier, AlgorithmIdentifier algorithmIdentifier2) {
        this.sigAlgId = algorithmIdentifier;
        this.digAlgId = algorithmIdentifier2;
        this.digestProvider = BcDefaultDigestProvider.INSTANCE;
    }

    public BcContentSignerBuilder setSecureRandom(SecureRandom secureRandom) {
        this.random = secureRandom;
        return this;
    }

    public ContentSigner build(AsymmetricKeyParameter asymmetricKeyParameter) throws OperatorCreationException {
        final Signer signer = this.createSigner(this.sigAlgId, this.digAlgId);
        if (this.random != null) {
            signer.init(true, new ParametersWithRandom(asymmetricKeyParameter, this.random));
        } else {
            signer.init(true, asymmetricKeyParameter);
        }
        return new ContentSigner(){
            private BcSignerOutputStream stream;
            {
                this.stream = new BcSignerOutputStream(signer);
            }

            public AlgorithmIdentifier getAlgorithmIdentifier() {
                return BcContentSignerBuilder.this.sigAlgId;
            }

            public OutputStream getOutputStream() {
                return this.stream;
            }

            public byte[] getSignature() {
                try {
                    return this.stream.getSignature();
                }
                catch (CryptoException cryptoException) {
                    throw new RuntimeOperatorException("exception obtaining signature: " + cryptoException.getMessage(), cryptoException);
                }
            }
        };
    }

    protected abstract Signer createSigner(AlgorithmIdentifier var1, AlgorithmIdentifier var2) throws OperatorCreationException;
}

