/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle149.operator.bc;

import java.security.SecureRandom;
import org.bouncycastle149.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle149.crypto.Wrapper;
import org.bouncycastle149.crypto.params.KeyParameter;
import org.bouncycastle149.crypto.params.ParametersWithRandom;
import org.bouncycastle149.operator.GenericKey;
import org.bouncycastle149.operator.OperatorException;
import org.bouncycastle149.operator.SymmetricKeyWrapper;
import org.bouncycastle149.operator.bc.OperatorUtils;

public class BcSymmetricKeyWrapper
extends SymmetricKeyWrapper {
    private SecureRandom random;
    private Wrapper wrapper;
    private KeyParameter wrappingKey;

    public BcSymmetricKeyWrapper(AlgorithmIdentifier algorithmIdentifier, Wrapper wrapper, KeyParameter keyParameter) {
        super(algorithmIdentifier);
        this.wrapper = wrapper;
        this.wrappingKey = keyParameter;
    }

    public BcSymmetricKeyWrapper setSecureRandom(SecureRandom secureRandom) {
        this.random = secureRandom;
        return this;
    }

    public byte[] generateWrappedKey(GenericKey genericKey) throws OperatorException {
        byte[] byArray = OperatorUtils.getKeyBytes(genericKey);
        if (this.random == null) {
            this.wrapper.init(true, this.wrappingKey);
        } else {
            this.wrapper.init(true, new ParametersWithRandom(this.wrappingKey, this.random));
        }
        return this.wrapper.wrap(byArray, 0, byArray.length);
    }
}

