/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle162.asn1.eac;

import java.io.IOException;
import org.bouncycastle162.asn1.ASN1ApplicationSpecific;
import org.bouncycastle162.asn1.ASN1EncodableVector;
import org.bouncycastle162.asn1.ASN1InputStream;
import org.bouncycastle162.asn1.ASN1Object;
import org.bouncycastle162.asn1.ASN1Primitive;
import org.bouncycastle162.asn1.DERApplicationSpecific;
import org.bouncycastle162.asn1.DEROctetString;
import org.bouncycastle162.asn1.eac.CertificateHolderAuthorization;
import org.bouncycastle162.asn1.eac.CertificateHolderReference;
import org.bouncycastle162.asn1.eac.CertificationAuthorityReference;
import org.bouncycastle162.asn1.eac.EACTags;
import org.bouncycastle162.asn1.eac.PackedDate;
import org.bouncycastle162.asn1.eac.PublicKeyDataObject;

public class CertificateBody
extends ASN1Object {
    ASN1InputStream seq;
    private ASN1ApplicationSpecific certificateProfileIdentifier;
    private ASN1ApplicationSpecific certificationAuthorityReference;
    private PublicKeyDataObject publicKey;
    private ASN1ApplicationSpecific certificateHolderReference;
    private CertificateHolderAuthorization certificateHolderAuthorization;
    private ASN1ApplicationSpecific certificateEffectiveDate;
    private ASN1ApplicationSpecific certificateExpirationDate;
    private int certificateType = 0;
    private static final int CPI = 1;
    private static final int CAR = 2;
    private static final int PK = 4;
    private static final int CHR = 8;
    private static final int CHA = 16;
    private static final int CEfD = 32;
    private static final int CExD = 64;
    public static final int profileType = 127;
    public static final int requestType = 13;

    private void setIso7816CertificateBody(ASN1ApplicationSpecific appSpe) throws IOException {
        ASN1Primitive obj;
        if (appSpe.getApplicationTag() != 78) {
            throw new IOException("Bad tag : not an iso7816 CERTIFICATE_CONTENT_TEMPLATE");
        }
        byte[] content = appSpe.getContents();
        ASN1InputStream aIS = new ASN1InputStream(content);
        block9: while ((obj = aIS.readObject()) != null) {
            if (!(obj instanceof ASN1ApplicationSpecific)) {
                throw new IOException("Not a valid iso7816 content : not a ASN1ApplicationSpecific Object :" + EACTags.encodeTag(appSpe) + obj.getClass());
            }
            ASN1ApplicationSpecific aSpe = (ASN1ApplicationSpecific)obj;
            switch (aSpe.getApplicationTag()) {
                case 41: {
                    this.setCertificateProfileIdentifier(aSpe);
                    continue block9;
                }
                case 2: {
                    this.setCertificationAuthorityReference(aSpe);
                    continue block9;
                }
                case 73: {
                    this.setPublicKey(PublicKeyDataObject.getInstance(aSpe.getObject(16)));
                    continue block9;
                }
                case 32: {
                    this.setCertificateHolderReference(aSpe);
                    continue block9;
                }
                case 76: {
                    this.setCertificateHolderAuthorization(new CertificateHolderAuthorization(aSpe));
                    continue block9;
                }
                case 37: {
                    this.setCertificateEffectiveDate(aSpe);
                    continue block9;
                }
                case 36: {
                    this.setCertificateExpirationDate(aSpe);
                    continue block9;
                }
            }
            this.certificateType = 0;
            throw new IOException("Not a valid iso7816 ASN1ApplicationSpecific tag " + aSpe.getApplicationTag());
        }
        aIS.close();
    }

    public CertificateBody(ASN1ApplicationSpecific certificateProfileIdentifier, CertificationAuthorityReference certificationAuthorityReference, PublicKeyDataObject publicKey, CertificateHolderReference certificateHolderReference, CertificateHolderAuthorization certificateHolderAuthorization, PackedDate certificateEffectiveDate, PackedDate certificateExpirationDate) {
        this.setCertificateProfileIdentifier(certificateProfileIdentifier);
        this.setCertificationAuthorityReference(new DERApplicationSpecific(2, certificationAuthorityReference.getEncoded()));
        this.setPublicKey(publicKey);
        this.setCertificateHolderReference(new DERApplicationSpecific(32, certificateHolderReference.getEncoded()));
        this.setCertificateHolderAuthorization(certificateHolderAuthorization);
        try {
            this.setCertificateEffectiveDate(new DERApplicationSpecific(false, 37, new DEROctetString(certificateEffectiveDate.getEncoding())));
            this.setCertificateExpirationDate(new DERApplicationSpecific(false, 36, new DEROctetString(certificateExpirationDate.getEncoding())));
        }
        catch (IOException e) {
            throw new IllegalArgumentException("unable to encode dates: " + e.getMessage());
        }
    }

    private CertificateBody(ASN1ApplicationSpecific obj) throws IOException {
        this.setIso7816CertificateBody(obj);
    }

    private ASN1Primitive profileToASN1Object() throws IOException {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(this.certificateProfileIdentifier);
        v.add(this.certificationAuthorityReference);
        v.add(new DERApplicationSpecific(false, 73, this.publicKey));
        v.add(this.certificateHolderReference);
        v.add(this.certificateHolderAuthorization);
        v.add(this.certificateEffectiveDate);
        v.add(this.certificateExpirationDate);
        return new DERApplicationSpecific(78, v);
    }

    private void setCertificateProfileIdentifier(ASN1ApplicationSpecific certificateProfileIdentifier) throws IllegalArgumentException {
        if (certificateProfileIdentifier.getApplicationTag() == 41) {
            this.certificateProfileIdentifier = certificateProfileIdentifier;
            this.certificateType |= 1;
        } else {
            throw new IllegalArgumentException("Not an Iso7816Tags.INTERCHANGE_PROFILE tag :" + EACTags.encodeTag(certificateProfileIdentifier));
        }
    }

    private void setCertificateHolderReference(ASN1ApplicationSpecific certificateHolderReference) throws IllegalArgumentException {
        if (certificateHolderReference.getApplicationTag() == 32) {
            this.certificateHolderReference = certificateHolderReference;
            this.certificateType |= 8;
        } else {
            throw new IllegalArgumentException("Not an Iso7816Tags.CARDHOLDER_NAME tag");
        }
    }

    private void setCertificationAuthorityReference(ASN1ApplicationSpecific certificationAuthorityReference) throws IllegalArgumentException {
        if (certificationAuthorityReference.getApplicationTag() == 2) {
            this.certificationAuthorityReference = certificationAuthorityReference;
            this.certificateType |= 2;
        } else {
            throw new IllegalArgumentException("Not an Iso7816Tags.ISSUER_IDENTIFICATION_NUMBER tag");
        }
    }

    private void setPublicKey(PublicKeyDataObject publicKey) {
        this.publicKey = PublicKeyDataObject.getInstance(publicKey);
        this.certificateType |= 4;
    }

    private ASN1Primitive requestToASN1Object() throws IOException {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(this.certificateProfileIdentifier);
        v.add(new DERApplicationSpecific(false, 73, this.publicKey));
        v.add(this.certificateHolderReference);
        return new DERApplicationSpecific(78, v);
    }

    public ASN1Primitive toASN1Primitive() {
        try {
            if (this.certificateType == 127) {
                return this.profileToASN1Object();
            }
            if (this.certificateType == 13) {
                return this.requestToASN1Object();
            }
        }
        catch (IOException e) {
            return null;
        }
        return null;
    }

    public int getCertificateType() {
        return this.certificateType;
    }

    public static CertificateBody getInstance(Object obj) throws IOException {
        if (obj instanceof CertificateBody) {
            return (CertificateBody)obj;
        }
        if (obj != null) {
            return new CertificateBody(ASN1ApplicationSpecific.getInstance(obj));
        }
        return null;
    }

    public PackedDate getCertificateEffectiveDate() {
        if ((this.certificateType & 0x20) == 32) {
            return new PackedDate(this.certificateEffectiveDate.getContents());
        }
        return null;
    }

    private void setCertificateEffectiveDate(ASN1ApplicationSpecific ced) throws IllegalArgumentException {
        if (ced.getApplicationTag() == 37) {
            this.certificateEffectiveDate = ced;
            this.certificateType |= 0x20;
        } else {
            throw new IllegalArgumentException("Not an Iso7816Tags.APPLICATION_EFFECTIVE_DATE tag :" + EACTags.encodeTag(ced));
        }
    }

    public PackedDate getCertificateExpirationDate() throws IOException {
        if ((this.certificateType & 0x40) == 64) {
            return new PackedDate(this.certificateExpirationDate.getContents());
        }
        throw new IOException("certificate Expiration Date not set");
    }

    private void setCertificateExpirationDate(ASN1ApplicationSpecific ced) throws IllegalArgumentException {
        if (ced.getApplicationTag() == 36) {
            this.certificateExpirationDate = ced;
            this.certificateType |= 0x40;
        } else {
            throw new IllegalArgumentException("Not an Iso7816Tags.APPLICATION_EXPIRATION_DATE tag");
        }
    }

    public CertificateHolderAuthorization getCertificateHolderAuthorization() throws IOException {
        if ((this.certificateType & 0x10) == 16) {
            return this.certificateHolderAuthorization;
        }
        throw new IOException("Certificate Holder Authorisation not set");
    }

    private void setCertificateHolderAuthorization(CertificateHolderAuthorization cha) {
        this.certificateHolderAuthorization = cha;
        this.certificateType |= 0x10;
    }

    public CertificateHolderReference getCertificateHolderReference() {
        return new CertificateHolderReference(this.certificateHolderReference.getContents());
    }

    public ASN1ApplicationSpecific getCertificateProfileIdentifier() {
        return this.certificateProfileIdentifier;
    }

    public CertificationAuthorityReference getCertificationAuthorityReference() throws IOException {
        if ((this.certificateType & 2) == 2) {
            return new CertificationAuthorityReference(this.certificationAuthorityReference.getContents());
        }
        throw new IOException("Certification authority reference not set");
    }

    public PublicKeyDataObject getPublicKey() {
        return this.publicKey;
    }
}

