/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle162.asn1.test;

import java.math.BigInteger;
import org.bouncycastle162.asn1.ASN1Enumerated;
import org.bouncycastle162.asn1.ASN1Integer;
import org.bouncycastle162.asn1.ASN1Sequence;
import org.bouncycastle162.util.Properties;
import org.bouncycastle162.util.encoders.Base64;
import org.bouncycastle162.util.encoders.Hex;
import org.bouncycastle162.util.test.SimpleTest;

public class ASN1IntegerTest
extends SimpleTest {
    private static final byte[] suspectKey = Base64.decode("MIGJAoGBAHNc+iExm94LUrJdPSJ4QJ9tDRuvaNmGVHpJ4X7a5zKI02v+2E7RotuiR2MHDJfVJkb9LUs2kb3XBlyENhtMLsbeH+3Muy3hGDlh/mLJSh1s4c5jDKBRYOHom7Uc8wP0P2+zBCA+OEdikNDFBaP5PbR2Xq9okG2kPh35M2quAiMTAgMBAAE=");

    public String getName() {
        return "ASN1Integer";
    }

    public void performTest() throws Exception {
        System.setProperty("org.bouncycastle162.asn1.allow_unsafe_integer", "true");
        ASN1Sequence.getInstance(suspectKey);
        this.testValidEncodingSingleByte();
        this.testValidEncodingMultiByte();
        this.testInvalidEncoding_00();
        this.testInvalidEncoding_ff();
        this.testInvalidEncoding_00_32bits();
        this.testInvalidEncoding_ff_32bits();
        this.testLooseValidEncoding_zero_32BAligned();
        this.testLooseValidEncoding_FF_32BAligned();
        this.testLooseValidEncoding_FF_32BAligned_1not0();
        this.testLooseValidEncoding_FF_32BAligned_2not0();
        this.testOversizedEncoding();
        System.setProperty("org.bouncycastle162.asn1.allow_unsafe_integer", "true");
        new ASN1Integer(Hex.decode("ffda47bfc776bcd269da4832626ac332adfca6dd835e8ecd83cd1ebe7d709b0e"));
        new ASN1Enumerated(Hex.decode("ffda47bfc776bcd269da4832626ac332adfca6dd835e8ecd83cd1ebe7d709b0e"));
        System.setProperty("org.bouncycastle162.asn1.allow_unsafe_integer", "false");
        try {
            new ASN1Integer(Hex.decode("ffda47bfc776bcd269da4832626ac332adfca6dd835e8ecd83cd1ebe7d709b"));
            this.fail("no exception");
        }
        catch (IllegalArgumentException e) {
            this.isEquals("malformed integer", e.getMessage());
        }
        this.isTrue(!Properties.setThreadOverride("org.bouncycastle162.asn1.allow_unsafe_integer", true));
        new ASN1Integer(Hex.decode("ffda47bfc776bcd269da4832626ac332adfca6dd835e8ecd83cd1ebe7d709b"));
        this.isTrue(Properties.removeThreadOverride("org.bouncycastle162.asn1.allow_unsafe_integer"));
        try {
            ASN1Sequence.getInstance(suspectKey);
            this.fail("no exception");
        }
        catch (IllegalArgumentException e) {
            this.isEquals("test 1", "failed to construct sequence from byte[]: corrupted stream detected", e.getMessage());
        }
        try {
            new ASN1Integer(Hex.decode("ffda47bfc776bcd269da4832626ac332adfca6dd835e8ecd83cd1ebe7d709b0e"));
            this.fail("no exception");
        }
        catch (IllegalArgumentException e) {
            this.isEquals("malformed integer", e.getMessage());
        }
        try {
            new ASN1Enumerated(Hex.decode("ffda47bfc776bcd269da4832626ac332adfca6dd835e8ecd83cd1ebe7d709b0e"));
            this.fail("no exception");
        }
        catch (IllegalArgumentException e) {
            this.isEquals("malformed enumerated", e.getMessage());
        }
    }

    public void testValidEncodingSingleByte() throws Exception {
        System.setProperty("org.bouncycastle162.asn1.allow_unsafe_integer", "false");
        byte[] rawInt = Hex.decode("10");
        ASN1Integer i = new ASN1Integer(rawInt);
        this.isEquals(i.getValue().intValue(), 16);
        System.setProperty("org.bouncycastle162.asn1.allow_unsafe_integer", "true");
        rawInt = Hex.decode("10");
        i = new ASN1Integer(rawInt);
        this.isEquals(i.getValue().intValue(), 16);
    }

    public void testValidEncodingMultiByte() throws Exception {
        System.setProperty("org.bouncycastle162.asn1.allow_unsafe_integer", "false");
        byte[] rawInt = Hex.decode("10FF");
        ASN1Integer i = new ASN1Integer(rawInt);
        this.isEquals(i.getValue().intValue(), 4351);
        System.setProperty("org.bouncycastle162.asn1.allow_unsafe_integer", "true");
        rawInt = Hex.decode("10FF");
        i = new ASN1Integer(rawInt);
        this.isEquals(i.getValue().intValue(), 4351);
    }

    public void testInvalidEncoding_00() throws Exception {
        System.setProperty("org.bouncycastle162.asn1.allow_unsafe_integer", "false");
        try {
            byte[] rawInt = Hex.decode("0010FF");
            ASN1Integer i = new ASN1Integer(rawInt);
            this.isEquals(i.getValue().intValue(), 4351);
            this.fail("Expecting illegal argument exception.");
        }
        catch (IllegalArgumentException e) {
            this.isEquals("malformed integer", e.getMessage());
        }
    }

    public void testInvalidEncoding_ff() throws Exception {
        System.setProperty("org.bouncycastle162.asn1.allow_unsafe_integer", "false");
        try {
            byte[] rawInt = Hex.decode("FF81FF");
            ASN1Integer i = new ASN1Integer(rawInt);
            this.fail("Expecting illegal argument exception.");
        }
        catch (IllegalArgumentException e) {
            this.isEquals("malformed integer", e.getMessage());
        }
    }

    public void testInvalidEncoding_00_32bits() throws Exception {
        System.setProperty("org.bouncycastle162.asn1.allow_unsafe_integer", "false");
        try {
            byte[] rawInt = Hex.decode("0000000010FF");
            ASN1Integer i = new ASN1Integer(rawInt);
            this.isEquals(i.getValue().intValue(), 4351);
            this.fail("Expecting illegal argument exception.");
        }
        catch (IllegalArgumentException e) {
            this.isEquals("malformed integer", e.getMessage());
        }
    }

    public void testInvalidEncoding_ff_32bits() throws Exception {
        System.setProperty("org.bouncycastle162.asn1.allow_unsafe_integer", "false");
        try {
            byte[] rawInt = Hex.decode("FFFFFFFF01FF");
            ASN1Integer i = new ASN1Integer(rawInt);
            this.fail("Expecting illegal argument exception.");
        }
        catch (IllegalArgumentException e) {
            this.isEquals("malformed integer", e.getMessage());
        }
    }

    public void testLooseValidEncoding_zero_32BAligned() throws Exception {
        System.setProperty("org.bouncycastle162.asn1.allow_unsafe_integer", "false");
        System.getProperties().put("org.bouncycastle162.asn1.allow_unsafe_integer", "true");
        byte[] rawInt = Hex.decode("00000010FF000000");
        ASN1Integer i = new ASN1Integer(rawInt);
        this.isEquals(0x10FF000000L, i.getValue().longValue());
    }

    public void testLooseValidEncoding_FF_32BAligned() throws Exception {
        System.setProperty("org.bouncycastle162.asn1.allow_unsafe_integer", "false");
        System.getProperties().put("org.bouncycastle162.asn1.allow_unsafe_integer", "true");
        byte[] rawInt = Hex.decode("FFFFFF10FF000000");
        ASN1Integer i = new ASN1Integer(rawInt);
        this.isEquals(-1026513960960L, i.getValue().longValue());
    }

    public void testLooseValidEncoding_FF_32BAligned_1not0() throws Exception {
        System.setProperty("org.bouncycastle162.asn1.allow_unsafe_integer", "false");
        System.getProperties().put("org.bouncycastle162.asn1.allow_unsafe_integer", "true");
        byte[] rawInt = Hex.decode("FFFEFF10FF000000");
        ASN1Integer i = new ASN1Integer(rawInt);
        this.isEquals(-282501490671616L, i.getValue().longValue());
    }

    public void testLooseValidEncoding_FF_32BAligned_2not0() throws Exception {
        System.setProperty("org.bouncycastle162.asn1.allow_unsafe_integer", "false");
        System.getProperties().put("org.bouncycastle162.asn1.allow_unsafe_integer", "true");
        byte[] rawInt = Hex.decode("FFFFFE10FF000000");
        ASN1Integer i = new ASN1Integer(rawInt);
        this.isEquals(-2126025588736L, i.getValue().longValue());
    }

    public void testOversizedEncoding() throws Exception {
        System.setProperty("org.bouncycastle162.asn1.allow_unsafe_integer", "false");
        System.getProperties().put("org.bouncycastle162.asn1.allow_unsafe_integer", "true");
        byte[] rawInt = Hex.decode("FFFFFFFE10FF000000000000");
        ASN1Integer i = new ASN1Integer(rawInt);
        this.isEquals(new BigInteger(Hex.decode("FFFFFFFE10FF000000000000")), i.getValue());
        rawInt = Hex.decode("FFFFFFFFFE10FF000000000000");
        try {
            new ASN1Integer(rawInt);
        }
        catch (IllegalArgumentException e) {
            this.isEquals("malformed integer", e.getMessage());
        }
    }

    public static void main(String[] args) {
        ASN1IntegerTest.runTest(new ASN1IntegerTest());
    }
}

