/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle162.asn1.test;

import java.util.Date;
import org.bouncycastle162.asn1.DERGeneralizedTime;
import org.bouncycastle162.asn1.cmc.BodyPartID;
import org.bouncycastle162.asn1.cmc.CMCFailInfo;
import org.bouncycastle162.asn1.cmc.CMCStatus;
import org.bouncycastle162.asn1.cmc.CMCStatusInfo;
import org.bouncycastle162.asn1.cmc.CMCStatusInfoBuilder;
import org.bouncycastle162.asn1.cmc.PendInfo;
import org.bouncycastle162.util.Strings;
import org.bouncycastle162.util.test.SimpleTest;

public class CMCStatusInfoTest
extends SimpleTest {
    public static void main(String[] args) {
        CMCStatusInfoTest.runTest(new CMCStatusInfoTest());
    }

    public String getName() {
        return "CMCStatusInfoTest";
    }

    public void performTest() throws Exception {
        CMCStatusInfoBuilder bldr = new CMCStatusInfoBuilder(CMCStatus.confirmRequired, new BodyPartID(10L));
        CMCStatusInfo cmsInfo = bldr.build();
        this.isTrue("Has statusString", null == cmsInfo.getStatusString());
        this.isEquals("Has other info", false, cmsInfo.hasOtherInfo());
        byte[] b = cmsInfo.getEncoded();
        CMCStatusInfo res = CMCStatusInfo.getInstance(b);
        this.isEquals("CMCStatus with no optional part", cmsInfo, res);
        this.isEquals("Has other info", false, res.hasOtherInfo());
        bldr = new CMCStatusInfoBuilder(CMCStatus.confirmRequired, new BodyPartID(10L)).setStatusString("Cats");
        cmsInfo = bldr.build();
        this.isEquals("Has other info", false, cmsInfo.hasOtherInfo());
        b = cmsInfo.getEncoded();
        res = CMCStatusInfo.getInstance(b);
        this.isEquals("CMCStatus with no optional part", cmsInfo, res);
        this.isEquals("Has other info", false, res.hasOtherInfo());
        bldr = new CMCStatusInfoBuilder(CMCStatus.confirmRequired, new BodyPartID(10L)).setStatusString("Cats").setOtherInfo(new PendInfo(Strings.toByteArray("fish"), new DERGeneralizedTime(new Date())));
        cmsInfo = bldr.build();
        this.isEquals("Must have other info", true, cmsInfo.hasOtherInfo());
        this.isEquals("Other is NOT fail info", false, cmsInfo.getOtherInfo().isFailInfo());
        b = cmsInfo.getEncoded();
        res = CMCStatusInfo.getInstance(b);
        this.isEquals("With optional info: PendInfo", cmsInfo, res);
        this.isEquals("Must have other info", true, res.hasOtherInfo());
        this.isEquals("Other is NOT fail info", false, res.getOtherInfo().isFailInfo());
        bldr = new CMCStatusInfoBuilder(CMCStatus.confirmRequired, new BodyPartID(10L)).setStatusString("Cats").setOtherInfo(CMCFailInfo.authDataFail);
        cmsInfo = bldr.build();
        this.isEquals("Must have other info", true, cmsInfo.hasOtherInfo());
        this.isEquals("Other is fail info", true, cmsInfo.getOtherInfo().isFailInfo());
        b = cmsInfo.getEncoded();
        res = CMCStatusInfo.getInstance(b);
        this.isEquals("With optional info: CMCFailInfo", cmsInfo, res);
        this.isEquals("Must have other info", true, res.hasOtherInfo());
        this.isEquals("Other is fail info", true, res.getOtherInfo().isFailInfo());
    }
}

