/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle162.asn1.test;

import java.io.IOException;
import java.math.BigInteger;
import org.bouncycastle162.asn1.ASN1Encodable;
import org.bouncycastle162.asn1.DEROctetString;
import org.bouncycastle162.asn1.DERSequence;
import org.bouncycastle162.asn1.cms.IssuerAndSerialNumber;
import org.bouncycastle162.asn1.crmf.DhSigStatic;
import org.bouncycastle162.asn1.x500.X500Name;
import org.bouncycastle162.util.Arrays;
import org.bouncycastle162.util.encoders.Hex;
import org.bouncycastle162.util.test.SimpleTest;

public class DhSigStaticTest
extends SimpleTest {
    public void performTest() throws Exception {
        DhSigStatic dhS = new DhSigStatic(new byte[20]);
        this.instanceTest(dhS);
        dhS = new DhSigStatic(new IssuerAndSerialNumber(new X500Name("CN=Test"), BigInteger.valueOf(20L)), new byte[20]);
        this.instanceTest(dhS);
        dhS = DhSigStatic.getInstance(new DERSequence(new DEROctetString(Hex.decode("0102030405060708090a"))));
        this.isTrue(Arrays.areEqual(Hex.decode("0102030405060708090a"), dhS.getHashValue()));
        try {
            dhS = DhSigStatic.getInstance(new DERSequence(new ASN1Encodable[]{new DEROctetString(Hex.decode("0102030405060708090a")), new DEROctetString(Hex.decode("0102030405060708090a")), new DEROctetString(Hex.decode("0102030405060708090a"))}));
            this.fail("no exception");
        }
        catch (IllegalArgumentException e) {
            this.isEquals(e.getMessage(), "sequence wrong length for DhSigStatic", e.getMessage());
        }
    }

    private void instanceTest(DhSigStatic bpd) throws IOException {
        byte[] b = bpd.getEncoded();
        DhSigStatic resBpd = DhSigStatic.getInstance(b);
        this.isTrue("hash check failed", this.areEqual(bpd.getHashValue(), resBpd.getHashValue()));
        this.isEquals("issuerAndSerial failed", bpd.getIssuerAndSerial(), resBpd.getIssuerAndSerial());
    }

    public String getName() {
        return "DhSigStaticTest";
    }

    public static void main(String[] args) throws Exception {
        DhSigStaticTest.runTest(new DhSigStaticTest());
    }
}

