/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle162.asn1.test;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import org.bouncycastle162.asn1.ASN1GeneralizedTime;
import org.bouncycastle162.asn1.DERGeneralizedTime;
import org.bouncycastle162.util.test.SimpleTest;

public class GeneralizedTimeTest
extends SimpleTest {
    String[] input = new String[]{"20020122122220", "20020122122220Z", "20020122122220-1000", "20020122122220+00", "20020122122220.1", "20020122122220.1Z", "20020122122220.1-1000", "20020122122220.1+00", "20020122122220.01", "20020122122220.01Z", "20020122122220.01-1000", "20020122122220.01+00", "20020122122220.001", "20020122122220.001Z", "20020122122220.001-1000", "20020122122220.001+00", "20020122122220.0001", "20020122122220.0001Z", "20020122122220.0001-1000", "20020122122220.0001+00", "20020122122220.0001+1000"};
    String[] output = new String[]{"20020122122220", "20020122122220GMT+00:00", "20020122122220GMT-10:00", "20020122122220GMT+00:00", "20020122122220.1", "20020122122220.1GMT+00:00", "20020122122220.1GMT-10:00", "20020122122220.1GMT+00:00", "20020122122220.01", "20020122122220.01GMT+00:00", "20020122122220.01GMT-10:00", "20020122122220.01GMT+00:00", "20020122122220.001", "20020122122220.001GMT+00:00", "20020122122220.001GMT-10:00", "20020122122220.001GMT+00:00", "20020122122220.0001", "20020122122220.0001GMT+00:00", "20020122122220.0001GMT-10:00", "20020122122220.0001GMT+00:00", "20020122122220.0001GMT+10:00"};
    String[] zOutput = new String[]{"20020122122220Z", "20020122122220Z", "20020122222220Z", "20020122122220Z", "20020122122220Z", "20020122122220Z", "20020122222220Z", "20020122122220Z", "20020122122220Z", "20020122122220Z", "20020122222220Z", "20020122122220Z", "20020122122220Z", "20020122122220Z", "20020122222220Z", "20020122122220Z", "20020122122220Z", "20020122122220Z", "20020122222220Z", "20020122122220Z", "20020122022220Z"};
    String[] mzOutput = new String[]{"20020122122220.000Z", "20020122122220.000Z", "20020122222220.000Z", "20020122122220.000Z", "20020122122220.100Z", "20020122122220.100Z", "20020122222220.100Z", "20020122122220.100Z", "20020122122220.010Z", "20020122122220.010Z", "20020122222220.010Z", "20020122122220.010Z", "20020122122220.001Z", "20020122122220.001Z", "20020122222220.001Z", "20020122122220.001Z", "20020122122220.000Z", "20020122122220.000Z", "20020122222220.000Z", "20020122122220.000Z", "20020122022220.000Z"};
    String[] derMzOutput = new String[]{"20020122122220Z", "20020122122220Z", "20020122222220Z", "20020122122220Z", "20020122122220.1Z", "20020122122220.1Z", "20020122222220.1Z", "20020122122220.1Z", "20020122122220.01Z", "20020122122220.01Z", "20020122222220.01Z", "20020122122220.01Z", "20020122122220.001Z", "20020122122220.001Z", "20020122222220.001Z", "20020122122220.001Z", "20020122122220Z", "20020122122220Z", "20020122222220Z", "20020122122220Z", "20020122022220Z"};
    String[] truncOutput = new String[]{"200201221222Z", "2002012212Z"};
    String[] derTruncOutput = new String[]{"20020122122200Z", "20020122120000Z"};

    public String getName() {
        return "GeneralizedTime";
    }

    public void performTest() throws Exception {
        ASN1GeneralizedTime t;
        int i;
        SimpleDateFormat dateF = new SimpleDateFormat("yyyyMMddHHmmss'Z'");
        dateF.setTimeZone(new SimpleTimeZone(0, "Z"));
        for (i = 0; i != this.input.length; ++i) {
            t = new ASN1GeneralizedTime(this.input[i]);
            if (this.output[i].indexOf(71) > 0) {
                if (!t.getTime().equals(this.output[i])) {
                    this.fail("failed conversion test");
                }
                if (dateF.format(t.getDate()).equals(this.zOutput[i])) continue;
                this.fail("failed date conversion test");
                continue;
            }
            String offset = this.calculateGMTOffset(t.getDate());
            if (t.getTime().equals(this.output[i] + offset)) continue;
            this.fail("failed conversion test");
        }
        dateF = new SimpleDateFormat("yyyyMMddHHmmss.SSS'Z'");
        dateF.setTimeZone(new SimpleTimeZone(0, "Z"));
        for (i = 0; i != this.input.length; ++i) {
            t = new ASN1GeneralizedTime(this.input[i]);
            if (dateF.format(t.getDate()).equals(this.mzOutput[i])) continue;
            this.fail("failed long date conversion test");
        }
        for (i = 0; i != this.mzOutput.length; ++i) {
            t = new DERGeneralizedTime(this.mzOutput[i]);
            if (this.areEqual(t.getEncoded(), new ASN1GeneralizedTime(this.derMzOutput[i]).getEncoded())) continue;
            this.fail("der encoding wrong");
        }
        for (i = 0; i != this.truncOutput.length; ++i) {
            t = new DERGeneralizedTime(this.truncOutput[i]);
            if (this.areEqual(t.getEncoded(), new ASN1GeneralizedTime(this.derTruncOutput[i]).getEncoded())) continue;
            this.fail("trunc der encoding wrong");
        }
    }

    private String calculateGMTOffset(Date date) {
        String sign = "+";
        TimeZone timeZone = TimeZone.getDefault();
        int offset = timeZone.getRawOffset();
        if (offset < 0) {
            sign = "-";
            offset = -offset;
        }
        int hours = offset / 3600000;
        int minutes = (offset - hours * 60 * 60 * 1000) / 60000;
        if (timeZone.useDaylightTime() && timeZone.inDaylightTime(date)) {
            hours += sign.equals("+") ? 1 : -1;
        }
        return "GMT" + sign + this.convert(hours) + ":" + this.convert(minutes);
    }

    private String convert(int time) {
        if (time < 10) {
            return "0" + time;
        }
        return Integer.toString(time);
    }

    public static void main(String[] args) {
        GeneralizedTimeTest.runTest(new GeneralizedTimeTest());
    }
}

