/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle162.asn1.test;

import java.util.Date;
import org.bouncycastle162.asn1.ASN1Encodable;
import org.bouncycastle162.asn1.ASN1GeneralizedTime;
import org.bouncycastle162.asn1.DERSequence;
import org.bouncycastle162.asn1.cmc.GetCRL;
import org.bouncycastle162.asn1.x500.X500Name;
import org.bouncycastle162.asn1.x500.X500NameBuilder;
import org.bouncycastle162.asn1.x500.style.BCStyle;
import org.bouncycastle162.asn1.x509.GeneralName;
import org.bouncycastle162.asn1.x509.ReasonFlags;
import org.bouncycastle162.util.test.SimpleTest;

public class GetCRLTest
extends SimpleTest {
    public static void main(String[] args) {
        GetCRLTest.runTest(new GetCRLTest());
    }

    public String getName() {
        return "GetCRLTest";
    }

    public void performTest() throws Exception {
        X500NameBuilder builder = new X500NameBuilder(BCStyle.INSTANCE);
        builder.addRDN(BCStyle.C, "AU");
        X500Name name = new X500Name(builder.build().toString());
        GetCRL crl = new GetCRL(name, new GeneralName(1, "/"), new ASN1GeneralizedTime(new Date()), new ReasonFlags(16));
        byte[] b = crl.getEncoded();
        GetCRL crlResp = GetCRL.getInstance(b);
        this.isEquals("IssuerName", crl.getIssuerName(), crlResp.getIssuerName());
        this.isEquals("cRLName", crl.getcRLName(), crlResp.getcRLName());
        this.isEquals("time", crl.getTime(), crlResp.getTime());
        this.isEquals("reasons", crl.getReasons(), crlResp.getReasons());
        try {
            GetCRL.getInstance(new DERSequence(new ASN1Encodable[0]));
            this.fail("Must not accept sequence less than 1");
        }
        catch (Throwable t) {
            this.isEquals("", t.getClass(), IllegalArgumentException.class);
        }
        try {
            GetCRL.getInstance(new DERSequence(new ASN1Encodable[5]));
            this.fail("Must not accept sequence larger than 5");
        }
        catch (Throwable t) {
            this.isEquals("", t.getClass(), IllegalArgumentException.class);
        }
        builder = new X500NameBuilder(BCStyle.INSTANCE);
        builder.addRDN(BCStyle.C, "AU");
        name = new X500Name(builder.build().toString());
        GeneralName generalName = null;
        ASN1GeneralizedTime generalizedTime = null;
        ReasonFlags flags = null;
        for (int t = 0; t < 8; ++t) {
            if ((t & 1) == 1) {
                generalName = new GeneralName(1, "/");
            }
            if ((t & 2) == 2) {
                generalizedTime = new ASN1GeneralizedTime(new Date());
            }
            if ((t & 4) == 4) {
                flags = new ReasonFlags(16);
            }
            GetCRL crl2 = new GetCRL(name, generalName, generalizedTime, flags);
            byte[] b2 = crl2.getEncoded();
            GetCRL crlResp2 = GetCRL.getInstance(b2);
            this.isEquals("IssuerName", crl2.getIssuerName(), crlResp2.getIssuerName());
            this.isEquals("cRLName", crl2.getcRLName(), crlResp2.getcRLName());
            this.isEquals("time", crl2.getTime(), crlResp2.getTime());
            this.isEquals("reasons", crl2.getReasons(), crlResp2.getReasons());
        }
    }
}

