/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle162.asn1.test;

import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;
import org.bouncycastle162.asn1.DERGeneralizedTime;
import org.bouncycastle162.asn1.DERUTCTime;
import org.bouncycastle162.util.test.SimpleTest;

public class LocaleTest
extends SimpleTest {
    public String getName() {
        return "LocaleTest";
    }

    private void doTestLocale(Locale l) throws Exception {
        long time = 1538063166000L;
        String timeString = "180927154606GMT+00:00";
        String longTimeString = "20180927154606Z";
        Locale.setDefault(l);
        this.isTrue("a", time == new DERUTCTime(timeString).getAdjustedDate().getTime());
        this.isTrue("b", time == new DERGeneralizedTime(longTimeString).getDate().getTime());
        this.isTrue("c", time == new DERUTCTime(new Date(time)).getAdjustedDate().getTime());
        this.isTrue("d", time == new DERGeneralizedTime(new Date(time)).getDate().getTime());
        Date d = new Date();
        this.isTrue("e", d.getTime() - d.getTime() % 1000L == new DERUTCTime(d).getAdjustedDate().getTime());
        this.isTrue("f", d.getTime() - d.getTime() % 1000L == new DERGeneralizedTime(d).getDate().getTime());
    }

    public void performTest() throws Exception {
        Locale defLocale = Locale.getDefault();
        Locale[] list = DateFormat.getAvailableLocales();
        for (int i = 0; i != list.length; ++i) {
            if (list[i].getCountry().equals("TH") || list[i].getCountry().equals("JP")) continue;
            this.doTestLocale(list[i]);
        }
        Locale.setDefault(defLocale);
    }

    public static void main(String[] args) {
        LocaleTest.runTest(new LocaleTest());
    }
}

