/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle162.asn1.test;

import java.io.IOException;
import org.bouncycastle162.asn1.ASN1InputStream;
import org.bouncycastle162.asn1.ASN1Integer;
import org.bouncycastle162.asn1.ASN1ObjectIdentifier;
import org.bouncycastle162.asn1.ASN1Sequence;
import org.bouncycastle162.asn1.ess.OtherCertID;
import org.bouncycastle162.asn1.test.ASN1UnitTest;
import org.bouncycastle162.asn1.x500.X500Name;
import org.bouncycastle162.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle162.asn1.x509.GeneralName;
import org.bouncycastle162.asn1.x509.GeneralNames;
import org.bouncycastle162.asn1.x509.IssuerSerial;

public class OtherCertIDUnitTest
extends ASN1UnitTest {
    public String getName() {
        return "OtherCertID";
    }

    public void performTest() throws Exception {
        AlgorithmIdentifier algId = new AlgorithmIdentifier(new ASN1ObjectIdentifier("1.2.2.3"));
        byte[] digest = new byte[20];
        IssuerSerial issuerSerial = new IssuerSerial(new GeneralNames(new GeneralName(new X500Name("CN=test"))), new ASN1Integer(1L));
        OtherCertID certID = new OtherCertID(algId, digest);
        this.checkConstruction(certID, algId, digest, null);
        certID = new OtherCertID(algId, digest, issuerSerial);
        this.checkConstruction(certID, algId, digest, issuerSerial);
        certID = OtherCertID.getInstance(null);
        if (certID != null) {
            this.fail("null getInstance() failed.");
        }
        try {
            OtherCertID.getInstance(new Object());
            this.fail("getInstance() failed to detect bad object.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private void checkConstruction(OtherCertID certID, AlgorithmIdentifier algId, byte[] digest, IssuerSerial issuerSerial) throws IOException {
        this.checkValues(certID, algId, digest, issuerSerial);
        certID = OtherCertID.getInstance(certID);
        this.checkValues(certID, algId, digest, issuerSerial);
        ASN1InputStream aIn = new ASN1InputStream(certID.toASN1Primitive().getEncoded());
        ASN1Sequence seq = (ASN1Sequence)aIn.readObject();
        certID = OtherCertID.getInstance(seq);
        this.checkValues(certID, algId, digest, issuerSerial);
    }

    private void checkValues(OtherCertID certID, AlgorithmIdentifier algId, byte[] digest, IssuerSerial issuerSerial) {
        this.checkMandatoryField("algorithmHash", algId, certID.getAlgorithmHash());
        this.checkMandatoryField("certHash", digest, certID.getCertHash());
        this.checkOptionalField("issuerSerial", issuerSerial, certID.getIssuerSerial());
    }

    public static void main(String[] args) {
        OtherCertIDUnitTest.runTest(new OtherCertIDUnitTest());
    }
}

