/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle162.asn1.test;

import java.math.BigInteger;
import org.bouncycastle162.asn1.ASN1Integer;
import org.bouncycastle162.asn1.cmp.PollReqContent;
import org.bouncycastle162.util.test.SimpleTest;

public class PollReqContentTest
extends SimpleTest {
    public String getName() {
        return "PollReqContentTest";
    }

    public void performTest() throws Exception {
        BigInteger one = BigInteger.valueOf(1L);
        BigInteger two = BigInteger.valueOf(2L);
        BigInteger[] ids = new BigInteger[]{one, two};
        PollReqContent c = new PollReqContent(ids);
        ASN1Integer[][] vs = c.getCertReqIds();
        this.isTrue(vs.length == 2);
        for (int i = 0; i != vs.length; ++i) {
            this.isTrue(vs[i].length == 1);
            this.isTrue(vs[i][0].getValue().equals(ids[i]));
        }
        BigInteger[] values = c.getCertReqIdValues();
        this.isTrue(values.length == 2);
        for (int i = 0; i != values.length; ++i) {
            this.isTrue(values[i].equals(ids[i]));
        }
        c = new PollReqContent(two);
        vs = c.getCertReqIds();
        this.isTrue(vs.length == 1);
        this.isTrue(vs[0].length == 1);
        this.isTrue(vs[0][0].getValue().equals(two));
    }

    public static void main(String[] args) {
        PollReqContentTest.runTest(new PollReqContentTest());
    }
}

