/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle162.asn1.test;

import org.bouncycastle162.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle162.util.encoders.Base64;
import org.bouncycastle162.util.test.SimpleTest;

public class PrivateKeyInfoTest
extends SimpleTest {
    private static final byte[] priv = Base64.decode("MC4CAQAwBQYDK2VwBCIEINTuctv5E1hK1bbY8fdp+K06/nwoy/HU++CXqI9EdVhC");
    private static final byte[] privWithPub = Base64.decode("MHICAQEwBQYDK2VwBCIEINTuctv5E1hK1bbY8fdp+K06/nwoy/HU++CXqI9EdVhCoB8wHQYKKoZIhvcNAQkJFDEPDA1DdXJkbGUgQ2hhaXJzgSEAGb9ECWmEzf6FQbrBZ9w7lshQhqowtrbLDFw4rXAxZuE=");

    public String getName() {
        return "PrivateKeyInfoTest";
    }

    public void performTest() throws Exception {
        PrivateKeyInfo privInfo1 = PrivateKeyInfo.getInstance(priv);
        this.isTrue(!privInfo1.hasPublicKey());
        PrivateKeyInfo privInfo2 = new PrivateKeyInfo(privInfo1.getPrivateKeyAlgorithm(), privInfo1.parsePrivateKey());
        this.isTrue("enc 1 failed", this.areEqual(priv, privInfo2.getEncoded()));
        privInfo1 = PrivateKeyInfo.getInstance(privWithPub);
        this.isTrue(privInfo1.hasPublicKey());
        privInfo2 = new PrivateKeyInfo(privInfo1.getPrivateKeyAlgorithm(), privInfo1.parsePrivateKey(), privInfo1.getAttributes(), privInfo1.getPublicKeyData().getOctets());
        this.isTrue("enc 2 failed", this.areEqual(privWithPub, privInfo2.getEncoded()));
    }

    public static void main(String[] args) {
        PrivateKeyInfoTest.runTest(new PrivateKeyInfoTest());
    }
}

