/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle162.cert.bc;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.bouncycastle162.asn1.oiw.OIWObjectIdentifiers;
import org.bouncycastle162.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle162.asn1.x509.AuthorityKeyIdentifier;
import org.bouncycastle162.asn1.x509.SubjectKeyIdentifier;
import org.bouncycastle162.cert.X509ExtensionUtils;
import org.bouncycastle162.crypto.digests.SHA1Digest;
import org.bouncycastle162.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle162.crypto.util.SubjectPublicKeyInfoFactory;
import org.bouncycastle162.operator.DigestCalculator;

public class BcX509ExtensionUtils
extends X509ExtensionUtils {
    public BcX509ExtensionUtils() {
        super(new SHA1DigestCalculator());
    }

    public BcX509ExtensionUtils(DigestCalculator calculator) {
        super(calculator);
    }

    public AuthorityKeyIdentifier createAuthorityKeyIdentifier(AsymmetricKeyParameter publicKey) throws IOException {
        return super.createAuthorityKeyIdentifier(SubjectPublicKeyInfoFactory.createSubjectPublicKeyInfo(publicKey));
    }

    public SubjectKeyIdentifier createSubjectKeyIdentifier(AsymmetricKeyParameter publicKey) throws IOException {
        return super.createSubjectKeyIdentifier(SubjectPublicKeyInfoFactory.createSubjectPublicKeyInfo(publicKey));
    }

    private static class SHA1DigestCalculator
    implements DigestCalculator {
        private ByteArrayOutputStream bOut = new ByteArrayOutputStream();

        private SHA1DigestCalculator() {
        }

        public AlgorithmIdentifier getAlgorithmIdentifier() {
            return new AlgorithmIdentifier(OIWObjectIdentifiers.idSHA1);
        }

        public OutputStream getOutputStream() {
            return this.bOut;
        }

        public byte[] getDigest() {
            byte[] bytes = this.bOut.toByteArray();
            this.bOut.reset();
            SHA1Digest sha1 = new SHA1Digest();
            sha1.update(bytes, 0, bytes.length);
            byte[] digest = new byte[sha1.getDigestSize()];
            sha1.doFinal(digest, 0);
            return digest;
        }
    }
}

