/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle162.cms.bc;

import java.io.InputStream;
import org.bouncycastle162.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle162.cms.CMSException;
import org.bouncycastle162.cms.RecipientOperator;
import org.bouncycastle162.cms.bc.BcKEKRecipient;
import org.bouncycastle162.cms.bc.EnvelopedDataHelper;
import org.bouncycastle162.crypto.BufferedBlockCipher;
import org.bouncycastle162.crypto.StreamCipher;
import org.bouncycastle162.crypto.io.CipherInputStream;
import org.bouncycastle162.crypto.params.KeyParameter;
import org.bouncycastle162.operator.InputDecryptor;
import org.bouncycastle162.operator.bc.BcSymmetricKeyUnwrapper;

public class BcKEKEnvelopedRecipient
extends BcKEKRecipient {
    public BcKEKEnvelopedRecipient(BcSymmetricKeyUnwrapper unwrapper) {
        super(unwrapper);
    }

    public RecipientOperator getRecipientOperator(AlgorithmIdentifier keyEncryptionAlgorithm, final AlgorithmIdentifier contentEncryptionAlgorithm, byte[] encryptedContentEncryptionKey) throws CMSException {
        KeyParameter secretKey = (KeyParameter)this.extractSecretKey(keyEncryptionAlgorithm, contentEncryptionAlgorithm, encryptedContentEncryptionKey);
        final Object dataCipher = EnvelopedDataHelper.createContentCipher(false, secretKey, contentEncryptionAlgorithm);
        return new RecipientOperator(new InputDecryptor(){

            public AlgorithmIdentifier getAlgorithmIdentifier() {
                return contentEncryptionAlgorithm;
            }

            public InputStream getInputStream(InputStream dataOut) {
                if (dataCipher instanceof BufferedBlockCipher) {
                    return new CipherInputStream(dataOut, (BufferedBlockCipher)dataCipher);
                }
                return new CipherInputStream(dataOut, (StreamCipher)dataCipher);
            }
        });
    }
}

