/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle162.cms.bc;

import java.io.InputStream;
import org.bouncycastle162.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle162.cms.CMSException;
import org.bouncycastle162.cms.RecipientOperator;
import org.bouncycastle162.cms.bc.BcKeyTransRecipient;
import org.bouncycastle162.cms.bc.EnvelopedDataHelper;
import org.bouncycastle162.crypto.BufferedBlockCipher;
import org.bouncycastle162.crypto.CipherParameters;
import org.bouncycastle162.crypto.StreamCipher;
import org.bouncycastle162.crypto.io.CipherInputStream;
import org.bouncycastle162.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle162.operator.InputDecryptor;

public class BcRSAKeyTransEnvelopedRecipient
extends BcKeyTransRecipient {
    public BcRSAKeyTransEnvelopedRecipient(AsymmetricKeyParameter key) {
        super(key);
    }

    public RecipientOperator getRecipientOperator(AlgorithmIdentifier keyEncryptionAlgorithm, final AlgorithmIdentifier contentEncryptionAlgorithm, byte[] encryptedContentEncryptionKey) throws CMSException {
        CipherParameters secretKey = this.extractSecretKey(keyEncryptionAlgorithm, contentEncryptionAlgorithm, encryptedContentEncryptionKey);
        final Object dataCipher = EnvelopedDataHelper.createContentCipher(false, secretKey, contentEncryptionAlgorithm);
        return new RecipientOperator(new InputDecryptor(){

            public AlgorithmIdentifier getAlgorithmIdentifier() {
                return contentEncryptionAlgorithm;
            }

            public InputStream getInputStream(InputStream dataIn) {
                if (dataCipher instanceof BufferedBlockCipher) {
                    return new CipherInputStream(dataIn, (BufferedBlockCipher)dataCipher);
                }
                return new CipherInputStream(dataIn, (StreamCipher)dataCipher);
            }
        });
    }
}

