/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle162.crypto.agreement;

import java.math.BigInteger;
import org.bouncycastle162.crypto.BasicAgreement;
import org.bouncycastle162.crypto.CipherParameters;
import org.bouncycastle162.crypto.params.ECDomainParameters;
import org.bouncycastle162.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle162.crypto.params.ECPublicKeyParameters;
import org.bouncycastle162.math.ec.ECAlgorithms;
import org.bouncycastle162.math.ec.ECPoint;

public class ECDHCBasicAgreement
implements BasicAgreement {
    ECPrivateKeyParameters key;

    public void init(CipherParameters key) {
        this.key = (ECPrivateKeyParameters)key;
    }

    public int getFieldSize() {
        return (this.key.getParameters().getCurve().getFieldSize() + 7) / 8;
    }

    public BigInteger calculateAgreement(CipherParameters pubKey) {
        ECPublicKeyParameters pub = (ECPublicKeyParameters)pubKey;
        ECDomainParameters params = this.key.getParameters();
        if (!params.equals(pub.getParameters())) {
            throw new IllegalStateException("ECDHC public key has wrong domain parameters");
        }
        BigInteger hd = params.getH().multiply(this.key.getD()).mod(params.getN());
        ECPoint pubPoint = ECAlgorithms.cleanPoint(params.getCurve(), pub.getQ());
        if (pubPoint.isInfinity()) {
            throw new IllegalStateException("Infinity is not a valid public key for ECDHC");
        }
        ECPoint P = pubPoint.multiply(hd).normalize();
        if (P.isInfinity()) {
            throw new IllegalStateException("Infinity is not a valid agreement value for ECDHC");
        }
        return P.getAffineXCoord().toBigInteger();
    }
}

