/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle162.crypto.agreement;

import org.bouncycastle162.crypto.CipherParameters;
import org.bouncycastle162.crypto.RawAgreement;
import org.bouncycastle162.crypto.params.X25519PrivateKeyParameters;
import org.bouncycastle162.crypto.params.X25519PublicKeyParameters;

public final class X25519Agreement
implements RawAgreement {
    private X25519PrivateKeyParameters privateKey;

    public void init(CipherParameters parameters) {
        this.privateKey = (X25519PrivateKeyParameters)parameters;
    }

    public int getAgreementSize() {
        return 32;
    }

    public void calculateAgreement(CipherParameters publicKey, byte[] buf, int off) {
        this.privateKey.generateSecret((X25519PublicKeyParameters)publicKey, buf, off);
    }
}

