/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle162.crypto.generators;

import java.math.BigInteger;
import org.bouncycastle162.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle162.crypto.AsymmetricCipherKeyPairGenerator;
import org.bouncycastle162.crypto.KeyGenerationParameters;
import org.bouncycastle162.crypto.generators.DHKeyGeneratorHelper;
import org.bouncycastle162.crypto.params.DHKeyGenerationParameters;
import org.bouncycastle162.crypto.params.DHParameters;
import org.bouncycastle162.crypto.params.DHPrivateKeyParameters;
import org.bouncycastle162.crypto.params.DHPublicKeyParameters;

public class DHKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private DHKeyGenerationParameters param;

    public void init(KeyGenerationParameters param) {
        this.param = (DHKeyGenerationParameters)param;
    }

    public AsymmetricCipherKeyPair generateKeyPair() {
        DHKeyGeneratorHelper helper = DHKeyGeneratorHelper.INSTANCE;
        DHParameters dhp = this.param.getParameters();
        BigInteger x = helper.calculatePrivate(dhp, this.param.getRandom());
        BigInteger y = helper.calculatePublic(dhp, x);
        return new AsymmetricCipherKeyPair(new DHPublicKeyParameters(y, dhp), new DHPrivateKeyParameters(x, dhp));
    }
}

