/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle162.crypto.generators;

import java.security.SecureRandom;
import org.bouncycastle162.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle162.crypto.AsymmetricCipherKeyPairGenerator;
import org.bouncycastle162.crypto.KeyGenerationParameters;
import org.bouncycastle162.crypto.params.Ed25519PrivateKeyParameters;
import org.bouncycastle162.crypto.params.Ed25519PublicKeyParameters;

public class Ed25519KeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private SecureRandom random;

    public void init(KeyGenerationParameters parameters) {
        this.random = parameters.getRandom();
    }

    public AsymmetricCipherKeyPair generateKeyPair() {
        Ed25519PrivateKeyParameters privateKey = new Ed25519PrivateKeyParameters(this.random);
        Ed25519PublicKeyParameters publicKey = privateKey.generatePublicKey();
        return new AsymmetricCipherKeyPair(publicKey, privateKey);
    }
}

