/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle162.crypto.signers;

import java.math.BigInteger;
import java.security.SecureRandom;
import org.bouncycastle162.crypto.CipherParameters;
import org.bouncycastle162.crypto.CryptoServicesRegistrar;
import org.bouncycastle162.crypto.DSAExt;
import org.bouncycastle162.crypto.params.ECDomainParameters;
import org.bouncycastle162.crypto.params.ECKeyParameters;
import org.bouncycastle162.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle162.crypto.params.ECPublicKeyParameters;
import org.bouncycastle162.crypto.params.ParametersWithRandom;
import org.bouncycastle162.math.ec.ECAlgorithms;
import org.bouncycastle162.math.ec.ECConstants;
import org.bouncycastle162.math.ec.ECMultiplier;
import org.bouncycastle162.math.ec.ECPoint;
import org.bouncycastle162.math.ec.FixedPointCombMultiplier;
import org.bouncycastle162.util.BigIntegers;

public class ECGOST3410Signer
implements DSAExt {
    ECKeyParameters key;
    SecureRandom random;

    public void init(boolean forSigning, CipherParameters param) {
        if (forSigning) {
            if (param instanceof ParametersWithRandom) {
                ParametersWithRandom rParam = (ParametersWithRandom)param;
                this.random = rParam.getRandom();
                this.key = (ECPrivateKeyParameters)rParam.getParameters();
            } else {
                this.random = CryptoServicesRegistrar.getSecureRandom();
                this.key = (ECPrivateKeyParameters)param;
            }
        } else {
            this.key = (ECPublicKeyParameters)param;
        }
    }

    public BigInteger getOrder() {
        return this.key.getParameters().getN();
    }

    public BigInteger[] generateSignature(byte[] message) {
        BigInteger s;
        ECPoint p;
        BigInteger r;
        BigInteger k;
        byte[] mRev = new byte[message.length];
        for (int i = 0; i != mRev.length; ++i) {
            mRev[i] = message[mRev.length - 1 - i];
        }
        BigInteger e = new BigInteger(1, mRev);
        ECDomainParameters ec = this.key.getParameters();
        BigInteger n = ec.getN();
        BigInteger d = ((ECPrivateKeyParameters)this.key).getD();
        ECMultiplier basePointMultiplier = this.createBasePointMultiplier();
        while ((k = BigIntegers.createRandomBigInteger(n.bitLength(), this.random)).equals(ECConstants.ZERO) || (r = (p = basePointMultiplier.multiply(ec.getG(), k).normalize()).getAffineXCoord().toBigInteger().mod(n)).equals(ECConstants.ZERO) || (s = k.multiply(e).add(d.multiply(r)).mod(n)).equals(ECConstants.ZERO)) {
        }
        return new BigInteger[]{r, s};
    }

    public boolean verifySignature(byte[] message, BigInteger r, BigInteger s) {
        ECPoint Q;
        byte[] mRev = new byte[message.length];
        for (int i = 0; i != mRev.length; ++i) {
            mRev[i] = message[mRev.length - 1 - i];
        }
        BigInteger e = new BigInteger(1, mRev);
        BigInteger n = this.key.getParameters().getN();
        if (r.compareTo(ECConstants.ONE) < 0 || r.compareTo(n) >= 0) {
            return false;
        }
        if (s.compareTo(ECConstants.ONE) < 0 || s.compareTo(n) >= 0) {
            return false;
        }
        BigInteger v = e.modInverse(n);
        BigInteger z1 = s.multiply(v).mod(n);
        BigInteger z2 = n.subtract(r).multiply(v).mod(n);
        ECPoint G = this.key.getParameters().getG();
        ECPoint point = ECAlgorithms.sumOfTwoMultiplies(G, z1, Q = ((ECPublicKeyParameters)this.key).getQ(), z2).normalize();
        if (point.isInfinity()) {
            return false;
        }
        BigInteger R = point.getAffineXCoord().toBigInteger().mod(n);
        return R.equals(r);
    }

    protected ECMultiplier createBasePointMultiplier() {
        return new FixedPointCombMultiplier();
    }
}

