/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle162.crypto.test;

import org.bouncycastle162.crypto.CipherParameters;
import org.bouncycastle162.crypto.DataLengthException;
import org.bouncycastle162.crypto.InvalidCipherTextException;
import org.bouncycastle162.crypto.OutputLengthException;
import org.bouncycastle162.crypto.modes.AEADBlockCipher;
import org.bouncycastle162.crypto.params.AEADParameters;
import org.bouncycastle162.util.Arrays;
import org.bouncycastle162.util.encoders.Hex;
import org.bouncycastle162.util.test.SimpleTestResult;
import org.bouncycastle162.util.test.Test;
import org.bouncycastle162.util.test.TestFailedException;

public class AEADTestUtil {
    public static void testTampering(Test test, AEADBlockCipher cipher, CipherParameters params) throws InvalidCipherTextException {
        byte[] plaintext = new byte[1000];
        for (int i = 0; i < plaintext.length; ++i) {
            plaintext[i] = (byte)i;
        }
        cipher.init(true, params);
        byte[] ciphertext = new byte[cipher.getOutputSize(plaintext.length)];
        int len = cipher.processBytes(plaintext, 0, plaintext.length, ciphertext, 0);
        cipher.doFinal(ciphertext, len);
        int macLength = cipher.getMac().length;
        cipher.init(false, params);
        byte[] tampered = new byte[ciphertext.length];
        byte[] output = new byte[plaintext.length];
        System.arraycopy(ciphertext, 0, tampered, 0, tampered.length);
        tampered[0] = (byte)(tampered[0] + 1);
        cipher.processBytes(tampered, 0, tampered.length, output, 0);
        try {
            cipher.doFinal(output, 0);
            throw new TestFailedException(new SimpleTestResult(false, test + " : tampering of ciphertext not detected."));
        }
        catch (InvalidCipherTextException invalidCipherTextException) {
            cipher.init(false, params);
            byte[] truncated = new byte[macLength - 1];
            System.arraycopy(ciphertext, 0, truncated, 0, truncated.length);
            cipher.processBytes(truncated, 0, truncated.length, output, 0);
            try {
                cipher.doFinal(output, 0);
                AEADTestUtil.fail(test, "tampering of ciphertext not detected.");
            }
            catch (InvalidCipherTextException invalidCipherTextException2) {
                // empty catch block
            }
            return;
        }
    }

    private static void fail(Test test, String message) {
        throw new TestFailedException(SimpleTestResult.failed(test, message));
    }

    private static void fail(Test test, String message, String expected, String result) {
        throw new TestFailedException(SimpleTestResult.failed(test, message, expected, result));
    }

    public static void testReset(Test test, AEADBlockCipher cipher1, AEADBlockCipher cipher2, CipherParameters params) throws InvalidCipherTextException {
        cipher1.init(true, params);
        byte[] plaintext = new byte[1000];
        byte[] ciphertext = new byte[cipher1.getOutputSize(plaintext.length)];
        AEADTestUtil.crypt(cipher1, plaintext, ciphertext);
        AEADTestUtil.checkReset(test, cipher1, params, true, plaintext, ciphertext);
        cipher2.init(false, params);
        AEADTestUtil.checkReset(test, cipher2, params, false, ciphertext, plaintext);
    }

    private static void checkReset(Test test, AEADBlockCipher cipher, CipherParameters params, boolean encrypt, byte[] pretext, byte[] posttext) throws InvalidCipherTextException {
        byte[] output = new byte[posttext.length];
        AEADTestUtil.crypt(cipher, pretext, output);
        AEADTestUtil.crypt(cipher, pretext, output);
        if (!Arrays.areEqual(output, posttext)) {
            AEADTestUtil.fail(test, (encrypt ? "Encrypt" : "Decrypt") + " did not reset cipher.");
        }
        cipher.processBytes(pretext, 0, 100, output, 0);
        cipher.init(encrypt, params);
        try {
            AEADTestUtil.crypt(cipher, pretext, output);
        }
        catch (DataLengthException e) {
            AEADTestUtil.fail(test, "Init did not reset data.");
        }
        if (!Arrays.areEqual(output, posttext)) {
            AEADTestUtil.fail(test, "Init did not reset data.", new String(Hex.encode(posttext)), new String(Hex.encode(output)));
        }
        cipher.processAADBytes(pretext, 0, 100);
        cipher.init(encrypt, params);
        try {
            AEADTestUtil.crypt(cipher, pretext, output);
        }
        catch (DataLengthException e) {
            AEADTestUtil.fail(test, "Init did not reset additional data.");
        }
        if (!Arrays.areEqual(output, posttext)) {
            AEADTestUtil.fail(test, "Init did not reset additional data.");
        }
        cipher.processBytes(pretext, 0, 100, output, 0);
        cipher.reset();
        try {
            AEADTestUtil.crypt(cipher, pretext, output);
        }
        catch (DataLengthException e) {
            AEADTestUtil.fail(test, "Init did not reset data.");
        }
        if (!Arrays.areEqual(output, posttext)) {
            AEADTestUtil.fail(test, "Reset did not reset data.");
        }
        cipher.processAADBytes(pretext, 0, 100);
        cipher.reset();
        try {
            AEADTestUtil.crypt(cipher, pretext, output);
        }
        catch (DataLengthException e) {
            AEADTestUtil.fail(test, "Init did not reset data.");
        }
        if (!Arrays.areEqual(output, posttext)) {
            AEADTestUtil.fail(test, "Reset did not reset additional data.");
        }
    }

    private static void crypt(AEADBlockCipher cipher, byte[] plaintext, byte[] output) throws InvalidCipherTextException {
        int len = cipher.processBytes(plaintext, 0, plaintext.length, output, 0);
        cipher.doFinal(output, len);
    }

    public static void testOutputSizes(Test test, AEADBlockCipher cipher, AEADParameters params) throws IllegalStateException, InvalidCipherTextException {
        int i;
        int maxPlaintext = cipher.getUnderlyingCipher().getBlockSize() * 10;
        byte[] plaintext = new byte[maxPlaintext];
        byte[] ciphertext = new byte[maxPlaintext * 2];
        cipher.init(true, params);
        cipher.doFinal(ciphertext, 0);
        int macLength = cipher.getMac().length;
        cipher.init(false, params);
        for (i = 0; i < macLength; ++i) {
            cipher.reset();
            if (cipher.getUpdateOutputSize(i) != 0) {
                AEADTestUtil.fail(test, "AE cipher should not produce update output with ciphertext length <= macSize");
            }
            if (cipher.getOutputSize(i) == 0) continue;
            AEADTestUtil.fail(test, "AE cipher should not produce output with ciphertext length <= macSize");
        }
        for (i = 0; i < plaintext.length; ++i) {
            int actualPTSize;
            int actualCTSize;
            cipher.init(true, params);
            int expectedCTUpdateSize = cipher.getUpdateOutputSize(i);
            int expectedCTOutputSize = cipher.getOutputSize(i);
            if (expectedCTUpdateSize < 0) {
                AEADTestUtil.fail(test, "Encryption update output size should not be < 0 for size " + i);
            }
            if (expectedCTOutputSize < 0) {
                AEADTestUtil.fail(test, "Encryption update output size should not be < 0 for size " + i);
            }
            if (expectedCTUpdateSize != (actualCTSize = cipher.processBytes(plaintext, 0, i, ciphertext, 0))) {
                AEADTestUtil.fail(test, "Encryption update output size did not match calculated for plaintext length " + i, String.valueOf(expectedCTUpdateSize), String.valueOf(actualCTSize));
            }
            if (expectedCTOutputSize != (actualCTSize += cipher.doFinal(ciphertext, actualCTSize))) {
                AEADTestUtil.fail(test, "Encryption actual final output size did not match calculated for plaintext length " + i, String.valueOf(expectedCTOutputSize), String.valueOf(actualCTSize));
            }
            cipher.init(false, params);
            int expectedPTUpdateSize = cipher.getUpdateOutputSize(actualCTSize);
            int expectedPTOutputSize = cipher.getOutputSize(actualCTSize);
            if (expectedPTOutputSize != i) {
                AEADTestUtil.fail(test, "Decryption update output size did not original plaintext length " + i, String.valueOf(expectedPTUpdateSize), String.valueOf(i));
            }
            if (expectedPTUpdateSize != (actualPTSize = cipher.processBytes(ciphertext, 0, actualCTSize, plaintext, 0))) {
                AEADTestUtil.fail(test, "Decryption update output size did not match calculated for plaintext length " + i, String.valueOf(expectedPTUpdateSize), String.valueOf(actualPTSize));
            }
            if (expectedPTOutputSize == (actualPTSize += cipher.doFinal(plaintext, actualPTSize))) continue;
            AEADTestUtil.fail(test, "Decryption update output size did not match calculated for plaintext length " + i, String.valueOf(expectedPTOutputSize), String.valueOf(actualPTSize));
        }
    }

    public static void testBufferSizeChecks(Test test, AEADBlockCipher cipher, AEADParameters params) throws IllegalStateException, InvalidCipherTextException {
        int blockSize = cipher.getUnderlyingCipher().getBlockSize();
        int maxPlaintext = blockSize * 10;
        byte[] plaintext = new byte[maxPlaintext];
        cipher.init(true, params);
        int expectedUpdateOutputSize = cipher.getUpdateOutputSize(plaintext.length);
        byte[] ciphertext = new byte[cipher.getOutputSize(plaintext.length)];
        try {
            cipher.processBytes(new byte[maxPlaintext - 1], 0, maxPlaintext, new byte[expectedUpdateOutputSize], 0);
            AEADTestUtil.fail(test, "processBytes should validate input buffer length");
        }
        catch (DataLengthException dataLengthException) {
            // empty catch block
        }
        cipher.reset();
        if (expectedUpdateOutputSize > 0) {
            int outputTrigger = 0;
            for (int i = 0; i < plaintext.length; ++i) {
                if (cipher.getUpdateOutputSize(1) != 0) {
                    outputTrigger = i + 1;
                    break;
                }
                cipher.processByte(plaintext[i], ciphertext, 0);
            }
            if (outputTrigger == 0) {
                AEADTestUtil.fail(test, "Failed to find output trigger size");
            }
            try {
                cipher.processByte(plaintext[0], new byte[cipher.getUpdateOutputSize(1) - 1], 0);
                AEADTestUtil.fail(test, "Encrypt processByte should validate output buffer length");
            }
            catch (OutputLengthException i) {
                // empty catch block
            }
            cipher.reset();
            try {
                cipher.processBytes(plaintext, 0, outputTrigger, new byte[cipher.getUpdateOutputSize(outputTrigger) - 1], 0);
                AEADTestUtil.fail(test, "Encrypt processBytes should validate output buffer length");
            }
            catch (OutputLengthException i) {
                // empty catch block
            }
            cipher.reset();
        }
        int actualOutputSize = cipher.processBytes(plaintext, 0, plaintext.length, ciphertext, 0);
        actualOutputSize += cipher.doFinal(ciphertext, actualOutputSize);
        int macSize = cipher.getMac().length;
        cipher.reset();
        try {
            cipher.processBytes(plaintext, 0, plaintext.length, ciphertext, 0);
            cipher.doFinal(new byte[cipher.getOutputSize(0) - 1], 0);
            AEADTestUtil.fail(test, "Encrypt doFinal should validate output buffer length");
        }
        catch (OutputLengthException outputLengthException) {
            // empty catch block
        }
        cipher.init(false, params);
        expectedUpdateOutputSize = cipher.getUpdateOutputSize(actualOutputSize);
        if (expectedUpdateOutputSize > 0) {
            int outputTrigger = 0;
            for (int i = 0; i < plaintext.length; ++i) {
                if (cipher.getUpdateOutputSize(1) != 0) {
                    outputTrigger = i + 1;
                    break;
                }
                cipher.processByte(ciphertext[i], plaintext, 0);
            }
            if (outputTrigger == 0) {
                AEADTestUtil.fail(test, "Failed to find output trigger size");
            }
            try {
                cipher.processByte(ciphertext[0], new byte[cipher.getUpdateOutputSize(1) - 1], 0);
                AEADTestUtil.fail(test, "Decrypt processByte should validate output buffer length");
            }
            catch (OutputLengthException i) {
                // empty catch block
            }
            cipher.reset();
            try {
                cipher.processBytes(ciphertext, 0, outputTrigger, new byte[cipher.getUpdateOutputSize(outputTrigger) - 1], 0);
                AEADTestUtil.fail(test, "Decrypt processBytes should validate output buffer length");
            }
            catch (OutputLengthException i) {
                // empty catch block
            }
        }
        cipher.reset();
        try {
            if (cipher.processBytes(ciphertext, 0, macSize - 1, plaintext, 0) != 0) {
                AEADTestUtil.fail(test, "AE cipher unexpectedly produced output");
            }
            cipher.doFinal(new byte[0], 0);
            AEADTestUtil.fail(test, "Decrypt doFinal should check ciphertext length");
        }
        catch (InvalidCipherTextException outputTrigger) {
            // empty catch block
        }
        try {
            for (int i = 2; i < plaintext.length; ++i) {
                cipher.init(true, params);
                int encrypted = cipher.processBytes(plaintext, 0, i, ciphertext, 0);
                encrypted += cipher.doFinal(ciphertext, encrypted);
                cipher.init(false, params);
                cipher.processBytes(ciphertext, 0, encrypted - 1, plaintext, 0);
                if (cipher.processByte(ciphertext[encrypted - 1], plaintext, 0) != 0) continue;
                cipher.doFinal(new byte[cipher.getOutputSize(0) - 1], 0);
                AEADTestUtil.fail(test, "Decrypt doFinal should check output length");
                cipher.reset();
                try {
                    cipher.processBytes(ciphertext, 0, actualOutputSize - 1, plaintext, 0);
                    cipher.doFinal(new byte[cipher.getOutputSize(0) - 1], 0);
                    AEADTestUtil.fail(test, "Decrypt doFinal should check ciphertext length");
                }
                catch (InvalidCipherTextException invalidCipherTextException) {
                    // empty catch block
                }
                cipher.reset();
            }
            AEADTestUtil.fail(test, "Decrypt doFinal test couldn't find a ciphertext length that buffered for doFinal");
        }
        catch (OutputLengthException outputLengthException) {
            // empty catch block
        }
    }

    static AEADParameters reuseKey(AEADParameters p) {
        return new AEADParameters(null, p.getMacSize(), p.getNonce(), p.getAssociatedText());
    }
}

