/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle162.crypto.test;

import java.security.SecureRandom;
import org.bouncycastle162.crypto.engines.AESWrapPadEngine;
import org.bouncycastle162.crypto.params.KeyParameter;
import org.bouncycastle162.crypto.params.ParametersWithIV;
import org.bouncycastle162.crypto.test.RNGUtils;
import org.bouncycastle162.util.Arrays;
import org.bouncycastle162.util.encoders.Hex;
import org.bouncycastle162.util.test.SimpleTest;

public class AESWrapPadTest
extends SimpleTest {
    private final int numOfRandomIterations = 100;

    private void wrapAndUnwrap(byte[] kek, byte[] key, byte[] expected) throws Exception {
        AESWrapPadEngine wrapper = new AESWrapPadEngine();
        wrapper.init(true, new KeyParameter(kek));
        byte[] cipherText = wrapper.wrap(key, 0, key.length);
        if (!this.areEqual(cipherText, expected)) {
            this.fail("Wrapped value does not match expected.");
        }
        wrapper.init(false, new KeyParameter(kek));
        byte[] plainText = wrapper.unwrap(cipherText, 0, cipherText.length);
        if (!this.areEqual(key, plainText)) {
            this.fail("Unwrapped value does not match original.");
        }
    }

    private void wrapAndUnwrap(byte[] kek, byte[] key) throws Exception {
        AESWrapPadEngine wrapper = new AESWrapPadEngine();
        wrapper.init(true, new KeyParameter(kek));
        byte[] cipherText = wrapper.wrap(key, 0, key.length);
        wrapper.init(false, new KeyParameter(kek));
        byte[] plainText = wrapper.unwrap(cipherText, 0, cipherText.length);
        if (!this.areEqual(key, plainText)) {
            this.fail("Unwrapped value does not match original.");
        }
    }

    private void wrapWithIVTest() throws Exception {
        byte[] kek = Hex.decode("5840df6e29b02af1ab493b705bf16ea1ae8338f4dcc176a8");
        byte[] key = Hex.decode("c37b7e6492584340bed12207808941155068f738");
        byte[] expected = Hex.decode("5cbdb3fb71351d0e628b85dbcba1a1890d4db26d1335e11d1aabea11124caad0");
        AESWrapPadEngine wrapper = new AESWrapPadEngine();
        wrapper.init(true, new ParametersWithIV(new KeyParameter(kek), Hex.decode("33333333")));
        byte[] cipherText = wrapper.wrap(key, 0, key.length);
        if (!this.areEqual(cipherText, expected)) {
            this.fail("Wrapped value does not match expected.");
        }
        wrapper.init(false, new ParametersWithIV(new KeyParameter(kek), Hex.decode("33333333")));
        byte[] plainText = wrapper.unwrap(cipherText, 0, cipherText.length);
        if (!this.areEqual(key, plainText)) {
            this.fail("Unwrapped value does not match original.");
        }
    }

    public String getName() {
        return "AESWrapPad";
    }

    public void performTest() throws Exception {
        byte[] kek = Hex.decode("5840df6e29b02af1ab493b705bf16ea1ae8338f4dcc176a8");
        byte[] key = Hex.decode("c37b7e6492584340bed12207808941155068f738");
        byte[] wrap = Hex.decode("138bdeaa9b8fa7fc61f97742e72248ee5ae6ae5360d1ae6a5f54f373fa543b6a");
        this.wrapAndUnwrap(kek, key, wrap);
        wrap = Hex.decode("afbeb0f07dfbf5419200f2ccb50bb24f");
        key = Hex.decode("466f7250617369");
        this.wrapAndUnwrap(kek, key, wrap);
        this.wrapWithIVTest();
        AESWrapPadEngine wrapper = new AESWrapPadEngine();
        byte[] pText = new byte[5 + key.length];
        System.arraycopy(key, 0, pText, 5, key.length);
        wrapper.init(true, new KeyParameter(kek));
        byte[] cText = wrapper.wrap(pText, 5, key.length);
        if (!Arrays.areEqual(cText, wrap)) {
            this.fail("failed offset wrap test expected " + new String(Hex.encode(wrap)) + " got " + new String(Hex.encode(cText)));
        }
        wrapper.init(false, new KeyParameter(kek));
        cText = new byte[6 + wrap.length];
        System.arraycopy(wrap, 0, cText, 6, wrap.length);
        pText = wrapper.unwrap(cText, 6, wrap.length);
        if (!Arrays.areEqual(pText, key)) {
            this.fail("failed offset unwrap test expected " + new String(Hex.encode(key)) + " got " + new String(Hex.encode(pText)));
        }
        SecureRandom rnd = new SecureRandom();
        for (int i = 0; i < 100; ++i) {
            boolean shouldIncrease;
            int kekLength = 128;
            boolean bl = shouldIncrease = (rnd.nextInt() & 1) != 0;
            if (shouldIncrease) {
                kekLength = 256;
            }
            kek = new byte[kekLength / 8];
            rnd.nextBytes(kek);
            int keyToWrapSize = RNGUtils.nextInt(rnd, 24) + 8;
            byte[] keyToWrap = new byte[keyToWrapSize];
            rnd.nextBytes(keyToWrap);
            this.wrapAndUnwrap(kek, keyToWrap);
        }
    }

    public static void main(String[] args) {
        AESWrapPadTest.runTest(new AESWrapPadTest());
    }
}

