/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle162.crypto.test;

import org.bouncycastle162.crypto.Digest;
import org.bouncycastle162.crypto.digests.EncodableDigest;
import org.bouncycastle162.util.Arrays;
import org.bouncycastle162.util.Memoable;
import org.bouncycastle162.util.encoders.Hex;
import org.bouncycastle162.util.test.SimpleTest;

public abstract class DigestTest
extends SimpleTest {
    private Digest digest;
    private String[] input;
    private String[] results;

    DigestTest(Digest digest, String[] input, String[] results) {
        this.digest = digest;
        this.input = input;
        this.results = results;
    }

    public String getName() {
        return this.digest.getAlgorithmName();
    }

    public void performTest() {
        byte[] resBuf = new byte[this.digest.getDigestSize()];
        for (int i = 0; i < this.input.length - 1; ++i) {
            byte[] m = this.toByteArray(this.input[i]);
            this.vectorTest(this.digest, i, resBuf, m, Hex.decode(this.results[i]));
        }
        this.offsetTest(this.digest, 0, this.toByteArray(this.input[0]), Hex.decode(this.results[0]));
        byte[] lastV = this.toByteArray(this.input[this.input.length - 1]);
        byte[] lastDigest = Hex.decode(this.results[this.input.length - 1]);
        this.vectorTest(this.digest, this.input.length - 1, resBuf, lastV, Hex.decode(this.results[this.input.length - 1]));
        this.testClone(resBuf, lastV, lastDigest);
        this.testMemo(resBuf, lastV, lastDigest);
        if (this.digest instanceof EncodableDigest) {
            this.testEncodedState(resBuf, lastV, lastDigest);
        }
    }

    private void testEncodedState(byte[] resBuf, byte[] input, byte[] expected) {
        this.digest.update(input, 0, input.length / 2);
        Digest copy1 = this.cloneDigest(((EncodableDigest)((Object)this.digest)).getEncodedState());
        Digest copy2 = this.cloneDigest(((EncodableDigest)((Object)copy1)).getEncodedState());
        this.digest.update(input, input.length / 2, input.length - input.length / 2);
        this.digest.doFinal(resBuf, 0);
        if (!this.areEqual(expected, resBuf)) {
            this.fail("failing state vector test", expected, new String(Hex.encode(resBuf)));
        }
        copy1.update(input, input.length / 2, input.length - input.length / 2);
        copy1.doFinal(resBuf, 0);
        if (!this.areEqual(expected, resBuf)) {
            this.fail("failing state copy1 vector test", expected, new String(Hex.encode(resBuf)));
        }
        copy2.update(input, input.length / 2, input.length - input.length / 2);
        copy2.doFinal(resBuf, 0);
        if (!this.areEqual(expected, resBuf)) {
            this.fail("failing state copy2 vector test", expected, new String(Hex.encode(resBuf)));
        }
    }

    private void testMemo(byte[] resBuf, byte[] input, byte[] expected) {
        Memoable m = (Memoable)((Object)this.digest);
        this.digest.update(input, 0, input.length / 2);
        Memoable copy1 = m.copy();
        Memoable copy2 = copy1.copy();
        this.digest.update(input, input.length / 2, input.length - input.length / 2);
        this.digest.doFinal(resBuf, 0);
        if (!this.areEqual(expected, resBuf)) {
            this.fail("failing memo vector test", this.results[this.results.length - 1], new String(Hex.encode(resBuf)));
        }
        m.reset(copy1);
        this.digest.update(input, input.length / 2, input.length - input.length / 2);
        this.digest.doFinal(resBuf, 0);
        if (!this.areEqual(expected, resBuf)) {
            this.fail("failing memo reset vector test", this.results[this.results.length - 1], new String(Hex.encode(resBuf)));
        }
        Digest md = (Digest)((Object)copy2);
        md.update(input, input.length / 2, input.length - input.length / 2);
        md.doFinal(resBuf, 0);
        if (!this.areEqual(expected, resBuf)) {
            this.fail("failing memo copy vector test", this.results[this.results.length - 1], new String(Hex.encode(resBuf)));
        }
    }

    private void testClone(byte[] resBuf, byte[] input, byte[] expected) {
        this.digest.update(input, 0, input.length / 2);
        Digest d = this.cloneDigest(this.digest);
        this.digest.update(input, input.length / 2, input.length - input.length / 2);
        this.digest.doFinal(resBuf, 0);
        if (!this.areEqual(expected, resBuf)) {
            this.fail("failing clone vector test", this.results[this.results.length - 1], new String(Hex.encode(resBuf)));
        }
        d.update(input, input.length / 2, input.length - input.length / 2);
        d.doFinal(resBuf, 0);
        if (!this.areEqual(expected, resBuf)) {
            this.fail("failing second clone vector test", this.results[this.results.length - 1], new String(Hex.encode(resBuf)));
        }
    }

    protected byte[] toByteArray(String input) {
        byte[] bytes = new byte[input.length()];
        for (int i = 0; i != bytes.length; ++i) {
            bytes[i] = (byte)input.charAt(i);
        }
        return bytes;
    }

    private void vectorTest(Digest digest, int count, byte[] resBuf, byte[] input, byte[] expected) {
        digest.update(input, 0, input.length);
        digest.doFinal(resBuf, 0);
        if (!this.areEqual(resBuf, expected)) {
            this.fail("Vector " + count + " failed got " + new String(Hex.encode(resBuf)));
        }
    }

    private void offsetTest(Digest digest, int count, byte[] input, byte[] expected) {
        byte[] resBuf = new byte[expected.length + 11];
        digest.update(input, 0, input.length);
        digest.doFinal(resBuf, 11);
        if (!this.areEqual(Arrays.copyOfRange(resBuf, 11, resBuf.length), expected)) {
            this.fail("Offset " + count + " failed got " + new String(Hex.encode(resBuf)));
        }
    }

    protected abstract Digest cloneDigest(Digest var1);

    protected Digest cloneDigest(byte[] encodedState) {
        throw new IllegalStateException("Unsupported");
    }

    protected void millionATest(String expected) {
        byte[] resBuf = new byte[this.digest.getDigestSize()];
        for (int i = 0; i < 1000000; ++i) {
            this.digest.update((byte)97);
        }
        this.digest.doFinal(resBuf, 0);
        if (!this.areEqual(resBuf, Hex.decode(expected))) {
            this.fail("Million a's failed", expected, new String(Hex.encode(resBuf)));
        }
    }

    protected void sixtyFourKTest(String expected) {
        byte[] resBuf = new byte[this.digest.getDigestSize()];
        for (int i = 0; i < 65536; ++i) {
            this.digest.update((byte)(i & 0xFF));
        }
        this.digest.doFinal(resBuf, 0);
        if (!this.areEqual(resBuf, Hex.decode(expected))) {
            this.fail("64k test failed", expected, new String(Hex.encode(resBuf)));
        }
    }
}

