/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle162.crypto.test;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import org.bouncycastle162.crypto.test.KDFDoublePipelineIteratorGeneratorTest;
import org.bouncycastle162.crypto.test.cavp.CAVPReader;
import org.bouncycastle162.crypto.test.cavp.KDFFeedbackCounterTests;
import org.bouncycastle162.crypto.test.cavp.KDFFeedbackNoCounterTests;
import org.bouncycastle162.util.test.SimpleTest;

public class KDFFeedbackGeneratorTest
extends SimpleTest {
    public String getName() {
        return this.getClass().getSimpleName();
    }

    public void performTest() throws Exception {
        KDFFeedbackGeneratorTest.testFeedbackCounter();
        KDFFeedbackGeneratorTest.testFeedbackNoCounter();
    }

    private static void testFeedbackCounter() {
        CAVPReader cavpReader = new CAVPReader(new KDFFeedbackCounterTests());
        InputStream stream = CAVPReader.class.getResourceAsStream("KDFFeedbackCounter_gen.rsp");
        InputStreamReader reader = new InputStreamReader(stream, Charset.forName("UTF-8"));
        cavpReader.setInput("KDFFeedbackCounter", reader);
        try {
            cavpReader.readAll();
        }
        catch (IOException e) {
            throw new IllegalStateException("Something is rotten in the state of Denmark ", e);
        }
    }

    private static void testFeedbackNoCounter() {
        CAVPReader cavpReader = new CAVPReader(new KDFFeedbackNoCounterTests());
        InputStream stream = CAVPReader.class.getResourceAsStream("KDFFeedbackNoCounter_gen.rsp");
        InputStreamReader reader = new InputStreamReader(stream, Charset.forName("UTF-8"));
        cavpReader.setInput("KDFFeedbackNoCounter", reader);
        try {
            cavpReader.readAll();
        }
        catch (IOException e) {
            throw new IllegalStateException("Something is rotten in the state of Denmark", e);
        }
    }

    public static void main(String[] args) {
        KDFFeedbackGeneratorTest.runTest(new KDFDoublePipelineIteratorGeneratorTest());
    }
}

