/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle162.crypto.test;

import java.security.SecureRandom;
import org.bouncycastle162.crypto.BlockCipher;
import org.bouncycastle162.crypto.InvalidCipherTextException;
import org.bouncycastle162.crypto.Wrapper;
import org.bouncycastle162.crypto.engines.DESEngine;
import org.bouncycastle162.crypto.engines.DESedeEngine;
import org.bouncycastle162.crypto.engines.RFC3211WrapEngine;
import org.bouncycastle162.crypto.modes.CBCBlockCipher;
import org.bouncycastle162.crypto.params.KeyParameter;
import org.bouncycastle162.crypto.params.ParametersWithIV;
import org.bouncycastle162.crypto.params.ParametersWithRandom;
import org.bouncycastle162.crypto.prng.FixedSecureRandom;
import org.bouncycastle162.util.Arrays;
import org.bouncycastle162.util.encoders.Hex;
import org.bouncycastle162.util.test.SimpleTest;

public class RFC3211WrapTest
extends SimpleTest {
    SecureRandom r1 = new FixedSecureRandom(Hex.decode("C436F541"));
    SecureRandom r2 = new FixedSecureRandom(Hex.decode("FA060A45"));

    public String getName() {
        return "RFC3211Wrap";
    }

    private void wrapTest(int id, BlockCipher engine, byte[] kek, byte[] iv, SecureRandom rand, byte[] in, byte[] out) throws Exception {
        RFC3211WrapEngine wrapper = new RFC3211WrapEngine(engine);
        wrapper.init(true, new ParametersWithRandom(new ParametersWithIV(new KeyParameter(kek), iv), rand));
        byte[] cText = wrapper.wrap(in, 0, in.length);
        if (!Arrays.areEqual(cText, out)) {
            this.fail("failed wrap test " + id + " expected " + new String(Hex.encode(out)) + " got " + new String(Hex.encode(cText)));
        }
        wrapper.init(false, new ParametersWithIV(new KeyParameter(kek), iv));
        byte[] pText = wrapper.unwrap(out, 0, out.length);
        if (!Arrays.areEqual(pText, in)) {
            this.fail("rfailed unwrap test " + id + " expected " + new String(Hex.encode(in)) + " got " + new String(Hex.encode(pText)));
        }
    }

    private void testCorruption() throws InvalidCipherTextException {
        byte[] block;
        RFC3211WrapEngine wrapper;
        byte[] iv;
        byte[] kek;
        block2: {
            kek = Hex.decode("D1DAA78615F287E6");
            iv = Hex.decode("EFE598EF21B33D6D");
            wrapper = new RFC3211WrapEngine(new DESEngine());
            wrapper.init(false, new ParametersWithIV(new KeyParameter(kek), iv));
            block = Hex.decode("ff739D838C627C897323A2F8C436F541");
            this.encryptBlock(kek, iv, block);
            try {
                wrapper.unwrap(block, 0, block.length);
                this.fail("bad length not detected");
            }
            catch (InvalidCipherTextException e) {
                if (e.getMessage().equals("wrapped key corrupted")) break block2;
                this.fail("wrong exception on length");
            }
        }
        block = Hex.decode("08639D838C627C897323A2F8C436F541");
        this.testChecksum(kek, iv, block, wrapper);
        block = Hex.decode("08736D838C627C897323A2F8C436F541");
        this.testChecksum(kek, iv, block, wrapper);
        block = Hex.decode("08739D638C627C897323A2F8C436F541");
        this.testChecksum(kek, iv, block, wrapper);
    }

    private void testChecksum(byte[] kek, byte[] iv, byte[] block, Wrapper wrapper) {
        block2: {
            this.encryptBlock(kek, iv, block);
            try {
                wrapper.unwrap(block, 0, block.length);
                this.fail("bad checksum not detected");
            }
            catch (InvalidCipherTextException e) {
                if (e.getMessage().equals("wrapped key corrupted")) break block2;
                this.fail("wrong exception");
            }
        }
    }

    private void encryptBlock(byte[] key, byte[] iv, byte[] cekBlock) {
        int i;
        CBCBlockCipher engine = new CBCBlockCipher(new DESEngine());
        engine.init(true, new ParametersWithIV(new KeyParameter(key), iv));
        for (i = 0; i < cekBlock.length; i += 8) {
            engine.processBlock(cekBlock, i, cekBlock, i);
        }
        for (i = 0; i < cekBlock.length; i += 8) {
            engine.processBlock(cekBlock, i, cekBlock, i);
        }
    }

    public void performTest() throws Exception {
        this.wrapTest(1, new DESEngine(), Hex.decode("D1DAA78615F287E6"), Hex.decode("EFE598EF21B33D6D"), this.r1, Hex.decode("8C627C897323A2F8"), Hex.decode("B81B2565EE373CA6DEDCA26A178B0C10"));
        this.wrapTest(2, new DESedeEngine(), Hex.decode("6A8970BF68C92CAEA84A8DF28510858607126380CC47AB2D"), Hex.decode("BAF1CA7931213C4E"), this.r2, Hex.decode("8C637D887223A2F965B566EB014B0FA5D52300A3F7EA40FFFC577203C71BAF3B"), Hex.decode("C03C514ABDB9E2C5AAC038572B5E24553876B377AAFB82ECA5A9D73F8AB143D9EC74E6CAD7DB260C"));
        this.testCorruption();
        RFC3211WrapEngine wrapper = new RFC3211WrapEngine(new DESEngine());
        ParametersWithIV params = new ParametersWithIV(new KeyParameter(new byte[16]), new byte[16]);
        byte[] buf = new byte[16];
        try {
            wrapper.init(true, params);
            wrapper.unwrap(buf, 0, buf.length);
            this.fail("failed unwrap state test.");
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (InvalidCipherTextException e) {
            this.fail("unexpected exception: " + e, e);
        }
        try {
            wrapper.init(false, params);
            wrapper.wrap(buf, 0, buf.length);
            this.fail("failed unwrap state test.");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            wrapper.init(false, params);
            wrapper.unwrap(buf, 0, buf.length / 2);
            this.fail("failed unwrap short test.");
        }
        catch (InvalidCipherTextException invalidCipherTextException) {
            // empty catch block
        }
    }

    public static void main(String[] args) {
        RFC3211WrapTest.runTest(new RFC3211WrapTest());
    }
}

