/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle162.crypto.test.cavp;

import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Properties;
import org.bouncycastle162.crypto.Mac;
import org.bouncycastle162.crypto.generators.KDFFeedbackBytesGenerator;
import org.bouncycastle162.crypto.params.KDFFeedbackParameters;
import org.bouncycastle162.crypto.test.cavp.CAVPListener;
import org.bouncycastle162.crypto.test.cavp.CAVPReader;
import org.bouncycastle162.util.Arrays;
import org.bouncycastle162.util.encoders.Hex;
import org.bouncycastle162.util.test.SimpleTestResult;
import org.bouncycastle162.util.test.TestFailedException;

public final class KDFFeedbackNoCounterTests
implements CAVPListener {
    private PrintWriter out;

    public void receiveCAVPVectors(String name, Properties config, Properties vectors) {
        Mac prf = CAVPReader.createPRF(config);
        KDFFeedbackBytesGenerator gen = new KDFFeedbackBytesGenerator(prf);
        int count = Integer.parseInt(vectors.getProperty("COUNT"));
        int l = Integer.parseInt(vectors.getProperty("L"));
        byte[] ki = Hex.decode(vectors.getProperty("KI"));
        byte[] iv = Hex.decode(vectors.getProperty("IV"));
        byte[] fixedInputData = Hex.decode(vectors.getProperty("FixedInputData"));
        KDFFeedbackParameters params = KDFFeedbackParameters.createWithoutCounter(ki, iv, fixedInputData);
        gen.init(params);
        byte[] koGenerated = new byte[l / 8];
        gen.generateBytes(koGenerated, 0, koGenerated.length);
        byte[] koVectors = Hex.decode(vectors.getProperty("KO"));
        KDFFeedbackNoCounterTests.compareKO(name, config, count, koGenerated, koVectors);
    }

    private static void compareKO(String name, Properties config, int test, byte[] calculatedOKM, byte[] testOKM) {
        if (!Arrays.areEqual(calculatedOKM, testOKM)) {
            throw new TestFailedException(new SimpleTestResult(false, name + " using " + config + " test " + test + " failed"));
        }
    }

    public void receiveCommentLine(String commentLine) {
    }

    public void receiveStart(String name) {
    }

    public void receiveEnd() {
        this.out.println(" *** *** *** ");
    }

    public void setup() {
        try {
            this.out = new PrintWriter(new FileWriter("KDFFeedbackNoCounter.gen"));
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public void tearDown() {
        this.out.close();
    }
}

