/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle162.crypto.tls;

import java.io.IOException;
import org.bouncycastle162.crypto.tls.AbstractTlsClient;
import org.bouncycastle162.crypto.tls.DefaultTlsCipherFactory;
import org.bouncycastle162.crypto.tls.DefaultTlsDHVerifier;
import org.bouncycastle162.crypto.tls.TlsAuthentication;
import org.bouncycastle162.crypto.tls.TlsCipherFactory;
import org.bouncycastle162.crypto.tls.TlsDHVerifier;
import org.bouncycastle162.crypto.tls.TlsFatalAlert;
import org.bouncycastle162.crypto.tls.TlsKeyExchange;
import org.bouncycastle162.crypto.tls.TlsPSKIdentity;
import org.bouncycastle162.crypto.tls.TlsPSKKeyExchange;
import org.bouncycastle162.crypto.tls.TlsUtils;

public class PSKTlsClient
extends AbstractTlsClient {
    protected TlsDHVerifier dhVerifier;
    protected TlsPSKIdentity pskIdentity;

    public PSKTlsClient(TlsPSKIdentity pskIdentity) {
        this(new DefaultTlsCipherFactory(), pskIdentity);
    }

    public PSKTlsClient(TlsCipherFactory cipherFactory, TlsPSKIdentity pskIdentity) {
        this(cipherFactory, new DefaultTlsDHVerifier(), pskIdentity);
    }

    public PSKTlsClient(TlsCipherFactory cipherFactory, TlsDHVerifier dhVerifier, TlsPSKIdentity pskIdentity) {
        super(cipherFactory);
        this.dhVerifier = dhVerifier;
        this.pskIdentity = pskIdentity;
    }

    public int[] getCipherSuites() {
        return new int[]{49207, 49205};
    }

    public TlsKeyExchange getKeyExchange() throws IOException {
        int keyExchangeAlgorithm = TlsUtils.getKeyExchangeAlgorithm(this.selectedCipherSuite);
        switch (keyExchangeAlgorithm) {
            case 13: 
            case 14: 
            case 15: 
            case 24: {
                return this.createPSKKeyExchange(keyExchangeAlgorithm);
            }
        }
        throw new TlsFatalAlert(80);
    }

    public TlsAuthentication getAuthentication() throws IOException {
        throw new TlsFatalAlert(80);
    }

    protected TlsKeyExchange createPSKKeyExchange(int keyExchange) {
        return new TlsPSKKeyExchange(keyExchange, this.supportedSignatureAlgorithms, this.pskIdentity, null, this.dhVerifier, null, this.namedCurves, this.clientECPointFormats, this.serverECPointFormats);
    }
}

