/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle162.crypto.tls;

import org.bouncycastle162.crypto.DSA;
import org.bouncycastle162.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle162.crypto.params.ECPublicKeyParameters;
import org.bouncycastle162.crypto.signers.ECDSASigner;
import org.bouncycastle162.crypto.signers.HMacDSAKCalculator;
import org.bouncycastle162.crypto.tls.TlsDSASigner;
import org.bouncycastle162.crypto.tls.TlsUtils;

public class TlsECDSASigner
extends TlsDSASigner {
    public boolean isValidPublicKey(AsymmetricKeyParameter publicKey) {
        return publicKey instanceof ECPublicKeyParameters;
    }

    protected DSA createDSAImpl(short hashAlgorithm) {
        return new ECDSASigner(new HMacDSAKCalculator(TlsUtils.createHash(hashAlgorithm)));
    }

    protected short getSignatureAlgorithm() {
        return 3;
    }
}

