/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle162.crypto.tls;

import org.bouncycastle162.crypto.AsymmetricBlockCipher;
import org.bouncycastle162.crypto.CipherParameters;
import org.bouncycastle162.crypto.CryptoException;
import org.bouncycastle162.crypto.Digest;
import org.bouncycastle162.crypto.Signer;
import org.bouncycastle162.crypto.digests.NullDigest;
import org.bouncycastle162.crypto.encodings.PKCS1Encoding;
import org.bouncycastle162.crypto.engines.RSABlindedEngine;
import org.bouncycastle162.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle162.crypto.params.ParametersWithRandom;
import org.bouncycastle162.crypto.params.RSAKeyParameters;
import org.bouncycastle162.crypto.signers.GenericSigner;
import org.bouncycastle162.crypto.signers.RSADigestSigner;
import org.bouncycastle162.crypto.tls.AbstractTlsSigner;
import org.bouncycastle162.crypto.tls.CombinedHash;
import org.bouncycastle162.crypto.tls.SignatureAndHashAlgorithm;
import org.bouncycastle162.crypto.tls.TlsUtils;

public class TlsRSASigner
extends AbstractTlsSigner {
    public byte[] generateRawSignature(SignatureAndHashAlgorithm algorithm, AsymmetricKeyParameter privateKey, byte[] hash) throws CryptoException {
        Signer signer = this.makeSigner(algorithm, true, true, new ParametersWithRandom(privateKey, this.context.getSecureRandom()));
        signer.update(hash, 0, hash.length);
        return signer.generateSignature();
    }

    public boolean verifyRawSignature(SignatureAndHashAlgorithm algorithm, byte[] sigBytes, AsymmetricKeyParameter publicKey, byte[] hash) throws CryptoException {
        Signer signer = this.makeSigner(algorithm, true, false, publicKey);
        signer.update(hash, 0, hash.length);
        return signer.verifySignature(sigBytes);
    }

    public Signer createSigner(SignatureAndHashAlgorithm algorithm, AsymmetricKeyParameter privateKey) {
        return this.makeSigner(algorithm, false, true, new ParametersWithRandom(privateKey, this.context.getSecureRandom()));
    }

    public Signer createVerifyer(SignatureAndHashAlgorithm algorithm, AsymmetricKeyParameter publicKey) {
        return this.makeSigner(algorithm, false, false, publicKey);
    }

    public boolean isValidPublicKey(AsymmetricKeyParameter publicKey) {
        return publicKey instanceof RSAKeyParameters && !publicKey.isPrivate();
    }

    protected Signer makeSigner(SignatureAndHashAlgorithm algorithm, boolean raw, boolean forSigning, CipherParameters cp) {
        if (algorithm != null != TlsUtils.isTLSv12(this.context)) {
            throw new IllegalStateException();
        }
        if (algorithm != null && algorithm.getSignature() != 1) {
            throw new IllegalStateException();
        }
        Digest d = raw ? new NullDigest() : (algorithm == null ? new CombinedHash() : TlsUtils.createHash(algorithm.getHash()));
        Signer s = algorithm != null ? new RSADigestSigner(d, TlsUtils.getOIDForHashAlgorithm(algorithm.getHash())) : new GenericSigner(this.createRSAImpl(), d);
        s.init(forSigning, cp);
        return s;
    }

    protected AsymmetricBlockCipher createRSAImpl() {
        return new PKCS1Encoding(new RSABlindedEngine());
    }
}

