/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle162.dvcs;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bouncycastle162.asn1.dvcs.Data;
import org.bouncycastle162.asn1.dvcs.TargetEtcChain;
import org.bouncycastle162.dvcs.DVCSConstructionException;
import org.bouncycastle162.dvcs.DVCSRequestData;
import org.bouncycastle162.dvcs.TargetChain;

public class VPKCRequestData
extends DVCSRequestData {
    private List chains;

    VPKCRequestData(Data data) throws DVCSConstructionException {
        super(data);
        TargetEtcChain[] certs = data.getCerts();
        if (certs == null) {
            throw new DVCSConstructionException("DVCSRequest.data.certs should be specified for VPKC service");
        }
        this.chains = new ArrayList(certs.length);
        for (int i = 0; i != certs.length; ++i) {
            this.chains.add(new TargetChain(certs[i]));
        }
    }

    public List getCerts() {
        return Collections.unmodifiableList(this.chains);
    }
}

