/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle162.math.ec.custom.sec;

import java.math.BigInteger;
import org.bouncycastle162.math.ec.ECCurve;
import org.bouncycastle162.math.ec.ECFieldElement;
import org.bouncycastle162.math.ec.ECLookupTable;
import org.bouncycastle162.math.ec.ECMultiplier;
import org.bouncycastle162.math.ec.ECPoint;
import org.bouncycastle162.math.ec.WTauNafMultiplier;
import org.bouncycastle162.math.ec.custom.sec.SecT571FieldElement;
import org.bouncycastle162.math.ec.custom.sec.SecT571K1Point;
import org.bouncycastle162.math.raw.Nat576;
import org.bouncycastle162.util.encoders.Hex;

public class SecT571K1Curve
extends ECCurve.AbstractF2m {
    private static final int SecT571K1_DEFAULT_COORDS = 6;
    protected SecT571K1Point infinity = new SecT571K1Point(this, null, null);

    public SecT571K1Curve() {
        super(571, 2, 5, 10);
        this.a = this.fromBigInteger(BigInteger.valueOf(0L));
        this.b = this.fromBigInteger(BigInteger.valueOf(1L));
        this.order = new BigInteger(1, Hex.decode("020000000000000000000000000000000000000000000000000000000000000000000000131850E1F19A63E4B391A8DB917F4138B630D84BE5D639381E91DEB45CFE778F637C1001"));
        this.cofactor = BigInteger.valueOf(4L);
        this.coord = 6;
    }

    protected ECCurve cloneCurve() {
        return new SecT571K1Curve();
    }

    public boolean supportsCoordinateSystem(int coord) {
        switch (coord) {
            case 6: {
                return true;
            }
        }
        return false;
    }

    protected ECMultiplier createDefaultMultiplier() {
        return new WTauNafMultiplier();
    }

    public int getFieldSize() {
        return 571;
    }

    public ECFieldElement fromBigInteger(BigInteger x) {
        return new SecT571FieldElement(x);
    }

    protected ECPoint createRawPoint(ECFieldElement x, ECFieldElement y, boolean withCompression) {
        return new SecT571K1Point((ECCurve)this, x, y, withCompression);
    }

    protected ECPoint createRawPoint(ECFieldElement x, ECFieldElement y, ECFieldElement[] zs, boolean withCompression) {
        return new SecT571K1Point(this, x, y, zs, withCompression);
    }

    public ECPoint getInfinity() {
        return this.infinity;
    }

    public boolean isKoblitz() {
        return true;
    }

    public int getM() {
        return 571;
    }

    public boolean isTrinomial() {
        return false;
    }

    public int getK1() {
        return 2;
    }

    public int getK2() {
        return 5;
    }

    public int getK3() {
        return 10;
    }

    public ECLookupTable createCacheSafeLookupTable(ECPoint[] points, int off, final int len) {
        int FE_LONGS = 9;
        final long[] table = new long[len * 9 * 2];
        int pos = 0;
        for (int i = 0; i < len; ++i) {
            ECPoint p = points[off + i];
            Nat576.copy64(((SecT571FieldElement)p.getRawXCoord()).x, 0, table, pos);
            Nat576.copy64(((SecT571FieldElement)p.getRawYCoord()).x, 0, table, pos += 9);
            pos += 9;
        }
        return new ECLookupTable(){

            public int getSize() {
                return len;
            }

            public ECPoint lookup(int index) {
                long[] x = Nat576.create64();
                long[] y = Nat576.create64();
                int pos = 0;
                for (int i = 0; i < len; ++i) {
                    long MASK = (i ^ index) - 1 >> 31;
                    for (int j = 0; j < 9; ++j) {
                        int n = j;
                        x[n] = x[n] ^ table[pos + j] & MASK;
                        int n2 = j;
                        y[n2] = y[n2] ^ table[pos + 9 + j] & MASK;
                    }
                    pos += 18;
                }
                return SecT571K1Curve.this.createRawPoint(new SecT571FieldElement(x), new SecT571FieldElement(y), false);
            }
        };
    }
}

