/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle162.openssl.jcajce;

import java.security.Provider;
import org.bouncycastle162.jcajce.util.DefaultJcaJceHelper;
import org.bouncycastle162.jcajce.util.JcaJceHelper;
import org.bouncycastle162.jcajce.util.NamedJcaJceHelper;
import org.bouncycastle162.jcajce.util.ProviderJcaJceHelper;
import org.bouncycastle162.openssl.PEMDecryptor;
import org.bouncycastle162.openssl.PEMDecryptorProvider;
import org.bouncycastle162.openssl.PEMException;
import org.bouncycastle162.openssl.PasswordException;
import org.bouncycastle162.openssl.jcajce.PEMUtilities;

public class JcePEMDecryptorProviderBuilder {
    private JcaJceHelper helper = new DefaultJcaJceHelper();

    public JcePEMDecryptorProviderBuilder setProvider(Provider provider) {
        this.helper = new ProviderJcaJceHelper(provider);
        return this;
    }

    public JcePEMDecryptorProviderBuilder setProvider(String providerName) {
        this.helper = new NamedJcaJceHelper(providerName);
        return this;
    }

    public PEMDecryptorProvider build(final char[] password) {
        return new PEMDecryptorProvider(){

            public PEMDecryptor get(final String dekAlgName) {
                return new PEMDecryptor(){

                    public byte[] decrypt(byte[] keyBytes, byte[] iv) throws PEMException {
                        if (password == null) {
                            throw new PasswordException("Password is null, but a password is required");
                        }
                        return PEMUtilities.crypt(false, JcePEMDecryptorProviderBuilder.this.helper, keyBytes, password, dekAlgName, iv);
                    }
                };
            }
        };
    }
}

