/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle162.pkcs;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import org.bouncycastle162.asn1.ASN1Primitive;
import org.bouncycastle162.asn1.pkcs.EncryptedPrivateKeyInfo;
import org.bouncycastle162.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle162.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle162.operator.InputDecryptor;
import org.bouncycastle162.operator.InputDecryptorProvider;
import org.bouncycastle162.pkcs.PKCSException;
import org.bouncycastle162.pkcs.PKCSIOException;
import org.bouncycastle162.util.io.Streams;

public class PKCS8EncryptedPrivateKeyInfo {
    private EncryptedPrivateKeyInfo encryptedPrivateKeyInfo;

    private static EncryptedPrivateKeyInfo parseBytes(byte[] pkcs8Encoding) throws IOException {
        try {
            return EncryptedPrivateKeyInfo.getInstance(ASN1Primitive.fromByteArray(pkcs8Encoding));
        }
        catch (ClassCastException e) {
            throw new PKCSIOException("malformed data: " + e.getMessage(), e);
        }
        catch (IllegalArgumentException e) {
            throw new PKCSIOException("malformed data: " + e.getMessage(), e);
        }
    }

    public PKCS8EncryptedPrivateKeyInfo(EncryptedPrivateKeyInfo encryptedPrivateKeyInfo) {
        this.encryptedPrivateKeyInfo = encryptedPrivateKeyInfo;
    }

    public PKCS8EncryptedPrivateKeyInfo(byte[] encryptedPrivateKeyInfo) throws IOException {
        this(PKCS8EncryptedPrivateKeyInfo.parseBytes(encryptedPrivateKeyInfo));
    }

    public AlgorithmIdentifier getEncryptionAlgorithm() {
        return this.encryptedPrivateKeyInfo.getEncryptionAlgorithm();
    }

    public byte[] getEncryptedData() {
        return this.encryptedPrivateKeyInfo.getEncryptedData();
    }

    public EncryptedPrivateKeyInfo toASN1Structure() {
        return this.encryptedPrivateKeyInfo;
    }

    public byte[] getEncoded() throws IOException {
        return this.encryptedPrivateKeyInfo.getEncoded();
    }

    public PrivateKeyInfo decryptPrivateKeyInfo(InputDecryptorProvider inputDecryptorProvider) throws PKCSException {
        try {
            InputDecryptor decrytor = inputDecryptorProvider.get(this.encryptedPrivateKeyInfo.getEncryptionAlgorithm());
            ByteArrayInputStream encIn = new ByteArrayInputStream(this.encryptedPrivateKeyInfo.getEncryptedData());
            return PrivateKeyInfo.getInstance(Streams.readAll(decrytor.getInputStream(encIn)));
        }
        catch (Exception e) {
            throw new PKCSException("unable to read encrypted data: " + e.getMessage(), e);
        }
    }
}

