/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle162.pkcs;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.bouncycastle162.asn1.pkcs.EncryptedPrivateKeyInfo;
import org.bouncycastle162.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle162.operator.OutputEncryptor;
import org.bouncycastle162.pkcs.PKCS8EncryptedPrivateKeyInfo;

public class PKCS8EncryptedPrivateKeyInfoBuilder {
    private PrivateKeyInfo privateKeyInfo;

    public PKCS8EncryptedPrivateKeyInfoBuilder(byte[] privateKeyInfo) {
        this(PrivateKeyInfo.getInstance(privateKeyInfo));
    }

    public PKCS8EncryptedPrivateKeyInfoBuilder(PrivateKeyInfo privateKeyInfo) {
        this.privateKeyInfo = privateKeyInfo;
    }

    public PKCS8EncryptedPrivateKeyInfo build(OutputEncryptor encryptor) {
        try {
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            OutputStream cOut = encryptor.getOutputStream(bOut);
            cOut.write(this.privateKeyInfo.getEncoded());
            cOut.close();
            return new PKCS8EncryptedPrivateKeyInfo(new EncryptedPrivateKeyInfo(encryptor.getAlgorithmIdentifier(), bOut.toByteArray()));
        }
        catch (IOException e) {
            throw new IllegalStateException("cannot encode privateKeyInfo");
        }
    }
}

