/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle162.pkcs.bc;

import java.io.InputStream;
import org.bouncycastle162.asn1.pkcs.PKCS12PBEParams;
import org.bouncycastle162.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle162.crypto.CipherParameters;
import org.bouncycastle162.crypto.ExtendedDigest;
import org.bouncycastle162.crypto.digests.SHA1Digest;
import org.bouncycastle162.crypto.generators.PKCS12ParametersGenerator;
import org.bouncycastle162.crypto.io.CipherInputStream;
import org.bouncycastle162.crypto.paddings.PaddedBufferedBlockCipher;
import org.bouncycastle162.operator.GenericKey;
import org.bouncycastle162.operator.InputDecryptor;
import org.bouncycastle162.operator.InputDecryptorProvider;
import org.bouncycastle162.pkcs.bc.PKCS12PBEUtils;

public class BcPKCS12PBEInputDecryptorProviderBuilder {
    private ExtendedDigest digest;

    public BcPKCS12PBEInputDecryptorProviderBuilder() {
        this(new SHA1Digest());
    }

    public BcPKCS12PBEInputDecryptorProviderBuilder(ExtendedDigest digest) {
        this.digest = digest;
    }

    public InputDecryptorProvider build(final char[] password) {
        return new InputDecryptorProvider(){

            public InputDecryptor get(final AlgorithmIdentifier algorithmIdentifier) {
                final PaddedBufferedBlockCipher engine = PKCS12PBEUtils.getEngine(algorithmIdentifier.getAlgorithm());
                PKCS12PBEParams pbeParams = PKCS12PBEParams.getInstance(algorithmIdentifier.getParameters());
                CipherParameters params = PKCS12PBEUtils.createCipherParameters(algorithmIdentifier.getAlgorithm(), BcPKCS12PBEInputDecryptorProviderBuilder.this.digest, engine.getBlockSize(), pbeParams, password);
                engine.init(false, params);
                return new InputDecryptor(){

                    public AlgorithmIdentifier getAlgorithmIdentifier() {
                        return algorithmIdentifier;
                    }

                    public InputStream getInputStream(InputStream input) {
                        return new CipherInputStream(input, engine);
                    }

                    public GenericKey getKey() {
                        return new GenericKey(PKCS12ParametersGenerator.PKCS12PasswordToBytes(password));
                    }
                };
            }
        };
    }
}

