/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle162.pqc.crypto.qtesla;

import java.security.SecureRandom;
import org.bouncycastle162.crypto.CipherParameters;
import org.bouncycastle162.crypto.CryptoServicesRegistrar;
import org.bouncycastle162.crypto.params.ParametersWithRandom;
import org.bouncycastle162.pqc.crypto.MessageSigner;
import org.bouncycastle162.pqc.crypto.qtesla.QTESLA;
import org.bouncycastle162.pqc.crypto.qtesla.QTESLAPrivateKeyParameters;
import org.bouncycastle162.pqc.crypto.qtesla.QTESLAPublicKeyParameters;
import org.bouncycastle162.pqc.crypto.qtesla.QTESLASecurityCategory;

public class QTESLASigner
implements MessageSigner {
    private QTESLAPublicKeyParameters publicKey;
    private QTESLAPrivateKeyParameters privateKey;
    private SecureRandom secureRandom;

    public void init(boolean forSigning, CipherParameters param) {
        if (forSigning) {
            if (param instanceof ParametersWithRandom) {
                this.secureRandom = ((ParametersWithRandom)param).getRandom();
                this.privateKey = (QTESLAPrivateKeyParameters)((ParametersWithRandom)param).getParameters();
            } else {
                this.secureRandom = CryptoServicesRegistrar.getSecureRandom();
                this.privateKey = (QTESLAPrivateKeyParameters)param;
            }
            this.publicKey = null;
            QTESLASecurityCategory.validate(this.privateKey.getSecurityCategory());
        } else {
            this.privateKey = null;
            this.publicKey = (QTESLAPublicKeyParameters)param;
            QTESLASecurityCategory.validate(this.publicKey.getSecurityCategory());
        }
    }

    public byte[] generateSignature(byte[] message) {
        byte[] sig = new byte[QTESLASecurityCategory.getSignatureSize(this.privateKey.getSecurityCategory())];
        switch (this.privateKey.getSecurityCategory()) {
            case 0: {
                QTESLA.signingI(sig, message, 0, message.length, this.privateKey.getSecret(), this.secureRandom);
                break;
            }
            case 1: {
                QTESLA.signingIIISize(sig, message, 0, message.length, this.privateKey.getSecret(), this.secureRandom);
                break;
            }
            case 2: {
                QTESLA.signingIIISpeed(sig, message, 0, message.length, this.privateKey.getSecret(), this.secureRandom);
                break;
            }
            case 3: {
                QTESLA.signingIP(sig, message, 0, message.length, this.privateKey.getSecret(), this.secureRandom);
                break;
            }
            case 4: {
                QTESLA.signingIIIP(sig, message, 0, message.length, this.privateKey.getSecret(), this.secureRandom);
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown security category: " + this.privateKey.getSecurityCategory());
            }
        }
        return sig;
    }

    public boolean verifySignature(byte[] message, byte[] signature) {
        int status;
        switch (this.publicKey.getSecurityCategory()) {
            case 0: {
                status = QTESLA.verifyingI(message, signature, 0, signature.length, this.publicKey.getPublicData());
                break;
            }
            case 1: {
                status = QTESLA.verifyingIIISize(message, signature, 0, signature.length, this.publicKey.getPublicData());
                break;
            }
            case 2: {
                status = QTESLA.verifyingIIISpeed(message, signature, 0, signature.length, this.publicKey.getPublicData());
                break;
            }
            case 3: {
                status = QTESLA.verifyingPI(message, signature, 0, signature.length, this.publicKey.getPublicData());
                break;
            }
            case 4: {
                status = QTESLA.verifyingPIII(message, signature, 0, signature.length, this.publicKey.getPublicData());
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown security category: " + this.publicKey.getSecurityCategory());
            }
        }
        return 0 == status;
    }
}

