/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle162.pqc.crypto.xmss;

import org.bouncycastle162.pqc.crypto.xmss.XMSSAddress;
import org.bouncycastle162.util.Pack;

final class HashTreeAddress
extends XMSSAddress {
    private static final int TYPE = 2;
    private static final int PADDING = 0;
    private final int padding;
    private final int treeHeight;
    private final int treeIndex;

    private HashTreeAddress(Builder builder) {
        super(builder);
        this.padding = 0;
        this.treeHeight = builder.treeHeight;
        this.treeIndex = builder.treeIndex;
    }

    protected byte[] toByteArray() {
        byte[] byteRepresentation = super.toByteArray();
        Pack.intToBigEndian(this.padding, byteRepresentation, 16);
        Pack.intToBigEndian(this.treeHeight, byteRepresentation, 20);
        Pack.intToBigEndian(this.treeIndex, byteRepresentation, 24);
        return byteRepresentation;
    }

    protected int getPadding() {
        return this.padding;
    }

    protected int getTreeHeight() {
        return this.treeHeight;
    }

    protected int getTreeIndex() {
        return this.treeIndex;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class Builder
    extends XMSSAddress.Builder<Builder> {
        private int treeHeight = 0;
        private int treeIndex = 0;

        protected Builder() {
            super(2);
        }

        protected Builder withTreeHeight(int val) {
            this.treeHeight = val;
            return this;
        }

        protected Builder withTreeIndex(int val) {
            this.treeIndex = val;
            return this;
        }

        @Override
        protected XMSSAddress build() {
            return new HashTreeAddress(this);
        }

        @Override
        protected Builder getThis() {
            return this;
        }
    }
}

