/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle162.pqc.jcajce.provider.mceliece;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import org.bouncycastle162.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle162.asn1.x509.X509ObjectIdentifiers;
import org.bouncycastle162.crypto.CipherParameters;
import org.bouncycastle162.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle162.crypto.params.ParametersWithRandom;
import org.bouncycastle162.pqc.crypto.mceliece.McElieceCipher;
import org.bouncycastle162.pqc.crypto.mceliece.McElieceKeyParameters;
import org.bouncycastle162.pqc.jcajce.provider.mceliece.McElieceKeysToParams;
import org.bouncycastle162.pqc.jcajce.provider.util.AsymmetricBlockCipher;

public class McEliecePKCSCipherSpi
extends AsymmetricBlockCipher
implements PKCSObjectIdentifiers,
X509ObjectIdentifiers {
    private McElieceCipher cipher;

    public McEliecePKCSCipherSpi(McElieceCipher cipher) {
        this.cipher = cipher;
    }

    protected void initCipherEncrypt(Key key, AlgorithmParameterSpec params, SecureRandom sr) throws InvalidKeyException, InvalidAlgorithmParameterException {
        CipherParameters param = McElieceKeysToParams.generatePublicKeyParameter((PublicKey)key);
        param = new ParametersWithRandom(param, sr);
        this.cipher.init(true, param);
        this.maxPlainTextSize = this.cipher.maxPlainTextSize;
        this.cipherTextSize = this.cipher.cipherTextSize;
    }

    protected void initCipherDecrypt(Key key, AlgorithmParameterSpec params) throws InvalidKeyException, InvalidAlgorithmParameterException {
        AsymmetricKeyParameter param = McElieceKeysToParams.generatePrivateKeyParameter((PrivateKey)key);
        this.cipher.init(false, param);
        this.maxPlainTextSize = this.cipher.maxPlainTextSize;
        this.cipherTextSize = this.cipher.cipherTextSize;
    }

    protected byte[] messageEncrypt(byte[] input) throws IllegalBlockSizeException, BadPaddingException {
        byte[] output = null;
        try {
            output = this.cipher.messageEncrypt(input);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return output;
    }

    protected byte[] messageDecrypt(byte[] input) throws IllegalBlockSizeException, BadPaddingException {
        byte[] output = null;
        try {
            output = this.cipher.messageDecrypt(input);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return output;
    }

    public String getName() {
        return "McEliecePKCS";
    }

    public int getKeySize(Key key) throws InvalidKeyException {
        McElieceKeyParameters mcElieceKeyParameters = key instanceof PublicKey ? (McElieceKeyParameters)McElieceKeysToParams.generatePublicKeyParameter((PublicKey)key) : (McElieceKeyParameters)McElieceKeysToParams.generatePrivateKeyParameter((PrivateKey)key);
        return this.cipher.getKeySize(mcElieceKeyParameters);
    }

    public static class McEliecePKCS
    extends McEliecePKCSCipherSpi {
        public McEliecePKCS() {
            super(new McElieceCipher());
        }
    }
}

