/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle162.pqc.jcajce.provider.qtesla;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.PrivateKey;
import org.bouncycastle162.asn1.ASN1Set;
import org.bouncycastle162.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle162.crypto.CipherParameters;
import org.bouncycastle162.pqc.crypto.qtesla.QTESLAPrivateKeyParameters;
import org.bouncycastle162.pqc.crypto.qtesla.QTESLASecurityCategory;
import org.bouncycastle162.pqc.crypto.util.PrivateKeyFactory;
import org.bouncycastle162.pqc.crypto.util.PrivateKeyInfoFactory;
import org.bouncycastle162.pqc.jcajce.interfaces.QTESLAKey;
import org.bouncycastle162.pqc.jcajce.spec.QTESLAParameterSpec;
import org.bouncycastle162.util.Arrays;

public class BCqTESLAPrivateKey
implements PrivateKey,
QTESLAKey {
    private static final long serialVersionUID = 1L;
    private transient QTESLAPrivateKeyParameters keyParams;
    private transient ASN1Set attributes;

    public BCqTESLAPrivateKey(QTESLAPrivateKeyParameters keyParams) {
        this.keyParams = keyParams;
    }

    public BCqTESLAPrivateKey(PrivateKeyInfo keyInfo) throws IOException {
        this.init(keyInfo);
    }

    private void init(PrivateKeyInfo keyInfo) throws IOException {
        this.attributes = keyInfo.getAttributes();
        this.keyParams = (QTESLAPrivateKeyParameters)PrivateKeyFactory.createKey(keyInfo);
    }

    public final String getAlgorithm() {
        return QTESLASecurityCategory.getName(this.keyParams.getSecurityCategory());
    }

    public String getFormat() {
        return "PKCS#8";
    }

    public QTESLAParameterSpec getParams() {
        return new QTESLAParameterSpec(this.getAlgorithm());
    }

    public byte[] getEncoded() {
        try {
            PrivateKeyInfo pki = PrivateKeyInfoFactory.createPrivateKeyInfo(this.keyParams, this.attributes);
            return pki.getEncoded();
        }
        catch (IOException e) {
            return null;
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof BCqTESLAPrivateKey) {
            BCqTESLAPrivateKey otherKey = (BCqTESLAPrivateKey)o;
            return this.keyParams.getSecurityCategory() == otherKey.keyParams.getSecurityCategory() && Arrays.areEqual(this.keyParams.getSecret(), otherKey.keyParams.getSecret());
        }
        return false;
    }

    public int hashCode() {
        return this.keyParams.getSecurityCategory() + 37 * Arrays.hashCode(this.keyParams.getSecret());
    }

    CipherParameters getKeyParams() {
        return this.keyParams;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        byte[] enc = (byte[])in.readObject();
        this.init(PrivateKeyInfo.getInstance(enc));
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeObject(this.getEncoded());
    }
}

