/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle162.pqc.math.ntru.polynomial.test;

import java.math.BigDecimal;
import java.security.SecureRandom;
import junit.framework.TestCase;
import org.bouncycastle162.pqc.math.ntru.polynomial.BigDecimalPolynomial;
import org.bouncycastle162.pqc.math.ntru.polynomial.BigIntPolynomial;
import org.bouncycastle162.pqc.math.ntru.polynomial.DenseTernaryPolynomial;
import org.bouncycastle162.pqc.math.ntru.polynomial.IntegerPolynomial;

public class BigDecimalPolynomialTest
extends TestCase {
    public void testMult() {
        DenseTernaryPolynomial d;
        IntegerPolynomial dInv;
        BigDecimalPolynomial a = new BigDecimalPolynomial(new BigIntPolynomial(new IntegerPolynomial(new int[]{4, -1, 9, 2, 1, -5, 12, -7, 0, -9, 5})));
        BigDecimalPolynomial b = new BigDecimalPolynomial(new BigIntPolynomial(new IntegerPolynomial(new int[]{-6, 0, 0, 13, 3, -2, -4, 10, 11, 2, -1})));
        BigDecimalPolynomial c = a.mult(b);
        BigDecimal[] expectedCoeffs = new BigDecimalPolynomial(new BigIntPolynomial(new IntegerPolynomial(new int[]{2, -189, 77, 124, -29, 0, -75, 124, -49, 267, 34}))).getCoeffs();
        BigDecimal[] cCoeffs = c.getCoeffs();
        BigDecimalPolynomialTest.assertEquals((int)expectedCoeffs.length, (int)cCoeffs.length);
        for (int i = 0; i != cCoeffs.length; ++i) {
            BigDecimalPolynomialTest.assertEquals((Object)expectedCoeffs[i], (Object)cCoeffs[i]);
        }
        SecureRandom random = new SecureRandom();
        while ((dInv = (d = DenseTernaryPolynomial.generateRandom(1001, 333, 334, random)).invertFq(2048)) == null) {
        }
        d.mod(2048);
        BigDecimalPolynomial e = new BigDecimalPolynomial(new BigIntPolynomial(d));
        BigIntPolynomial f = new BigIntPolynomial(dInv);
        IntegerPolynomial g = new IntegerPolynomial(e.mult(f).round());
        g.modPositive(2048);
        BigDecimalPolynomialTest.assertTrue((boolean)g.equalsOne());
    }
}

