/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle162.tsp;

import org.bouncycastle162.asn1.ASN1Integer;
import org.bouncycastle162.asn1.tsp.Accuracy;

public class GenTimeAccuracy {
    private Accuracy accuracy;

    public GenTimeAccuracy(Accuracy accuracy) {
        this.accuracy = accuracy;
    }

    public int getSeconds() {
        return this.getTimeComponent(this.accuracy.getSeconds());
    }

    public int getMillis() {
        return this.getTimeComponent(this.accuracy.getMillis());
    }

    public int getMicros() {
        return this.getTimeComponent(this.accuracy.getMicros());
    }

    private int getTimeComponent(ASN1Integer time) {
        if (time != null) {
            return time.getValue().intValue();
        }
        return 0;
    }

    public String toString() {
        return this.getSeconds() + "." + this.format(this.getMillis()) + this.format(this.getMicros());
    }

    private String format(int v) {
        if (v < 10) {
            return "00" + v;
        }
        if (v < 100) {
            return "0" + v;
        }
        return Integer.toString(v);
    }
}

