/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.eepsp.service.explain.verify.impl.services;

import api.VoucherFileUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ygsoft.abc.eepsp.service.explain.common.type.ElecVoucherBOEnum;
import com.ygsoft.abc.eepsp.service.explain.verify.domain.vo.VerifyDetailVO;
import com.ygsoft.abc.eepsp.service.explain.verify.domain.vo.VerifyRecordVO;
import com.ygsoft.abc.eepsp.service.explain.verify.services.IVerifySignService;
import com.ygsoft.abc.eepsp.service.explain.verify.strategy.EleVoucherParseFactory;
import com.ygsoft.abc.eepsp.service.explain.verify.strategy.IEleVoucherParseStrategy;
import com.ygsoft.abc.eepsp.service.explain.verify.util.ZipUtil;
import com.ygsoft.abc.eepsp.service.explain.voucher.domain.bo.AirTickItemBO;
import com.ygsoft.abc.eepsp.service.explain.voucher.domain.bo.AtrIssuerBO;
import com.ygsoft.abc.eepsp.service.explain.voucher.domain.bo.BankReconItemBO;
import com.ygsoft.abc.eepsp.service.explain.voucher.domain.bo.BkerIssuerBO;
import com.ygsoft.abc.eepsp.service.explain.voucher.domain.bo.BkrsBO;
import com.ygsoft.abc.eepsp.service.explain.voucher.domain.bo.InvOrdIssuerBO;
import com.ygsoft.abc.eepsp.service.explain.voucher.domain.bo.InvTlfIssuerBO;
import com.ygsoft.abc.eepsp.service.explain.voucher.domain.bo.NtrevGpmIssuerBO;
import com.ygsoft.abc.eepsp.service.explain.voucher.domain.bo.NtrevGpmItemBO;
import com.ygsoft.abc.eepsp.service.explain.voucher.domain.bo.RaiIssuerBO;
import com.ygsoft.abc.eepsp.service.explain.voucher.domain.bo.TaxableItemBO;
import com.ygsoft.abc.eepsp.service.explain.voucher.domain.bo.TollFeeItemBO;
import com.ygsoft.abc.eepsp.service.explain.voucher.domain.bo.origin.AtrIssuerOriginBO;
import com.ygsoft.abc.eepsp.service.explain.voucher.domain.bo.origin.BkerIssuerOriginBO;
import com.ygsoft.abc.eepsp.service.explain.voucher.domain.bo.origin.BkrsOriginBO;
import com.ygsoft.abc.eepsp.service.explain.voucher.domain.bo.origin.InvOrdIssuerOriginBO;
import com.ygsoft.abc.eepsp.service.explain.voucher.domain.bo.origin.InvSpclIssuerOriginBO;
import com.ygsoft.abc.eepsp.service.explain.voucher.domain.bo.origin.InvTlfIssuerOriginBO;
import com.ygsoft.abc.eepsp.service.explain.voucher.domain.bo.origin.NtrevGpmIssuerOriginBO;
import com.ygsoft.abc.eepsp.service.explain.voucher.domain.bo.origin.RaiIssuerOriginBO;
import com.ygsoft.abc.eepsp.service.explain.voucher.domain.bo.origin.gpm.NtrevCertificateInforBO;
import com.ygsoft.abc.eepsp.service.explain.voucher.domain.bo.origin.gpm.NtrevExecAgencyPartyBO;
import com.ygsoft.abc.eepsp.service.explain.voucher.domain.bo.origin.gpm.NtrevHeaderBO;
import com.ygsoft.abc.eepsp.service.explain.voucher.domain.bo.origin.gpm.NtrevInvDataMainBO;
import com.ygsoft.abc.eepsp.service.explain.voucher.domain.bo.origin.gpm.NtrevMainExtBO;
import com.ygsoft.abc.eepsp.service.explain.voucher.domain.bo.origin.gpm.NtrevPayerPartyBO;
import com.ygsoft.abc.eepsp.service.explain.voucher.domain.bo.origin.gpm.NtrevSealInfoBO;
import com.ygsoft.abc.eepsp.service.explain.voucher.domain.bo.origin.gpm.NtrevSignInfoBO;
import com.ygsoft.abc.service.annotation.TLog;
import com.ygsoft.abc.service.exception.AbcIllegalArgumentException;
import com.ygsoft.abc.service.exception.CheckFailedException;
import com.ygsoft.abc.service.tool.BlockCollectionUtil;
import com.ygsoft.abc.service.tool.BlockDateUtil;
import com.ygsoft.abc.service.tool.PreconditionUtil;
import com.ygsoft.ecp.service.log.EcpLogFactory;
import com.ygsoft.ecp.service.log.IEcpLog;
import com.ygsoft.ecp.service.tool.StringUtil;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.transaction.Transactional;
import org.apache.commons.collections4.map.HashedMap;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
@Transactional
public class VerifySignService
implements IVerifySignService {
    private static final IEcpLog LOG = EcpLogFactory.getLog(VerifySignService.class);

    @Override
    @TLog(text="\u89e3\u6790ZIP\u4e2dXBRL")
    public Object parseXBRL(MultipartFile zip) {
        byte[] data = ZipUtil.getXbrlFromZip(zip);
        if (null == data) {
            throw CheckFailedException.newInstance((String)"\u83b7\u53d6xbrl\u6587\u4ef6\u5931\u8d25\u3002");
        }
        IEleVoucherParseStrategy instance = EleVoucherParseFactory.getInstance(zip.getOriginalFilename());
        try {
            String xbrl = new String(data, "UTF-8");
            PreconditionUtil.checkNotTrimEmpty((String)xbrl, (String)"xbrl\u6587\u4ef6\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a\u3002");
            ElecVoucherBOEnum elecVoucherBO = instance.getElecVoucherBOEunm(zip);
            String configId = elecVoucherBO.getConfigId();
            PreconditionUtil.checkNotTrimEmpty((String)configId, (String)"configId\u4e0d\u80fd\u4e3a\u7a7a\u3002");
            JSONObject xbrl2Json = VoucherFileUtil.xbrl2Json((String)xbrl, (String)configId);
            xbrl2Json.put("voucherType", (Object)elecVoucherBO.ordinal());
            Class<?> boClazz = elecVoucherBO.getBoClazz();
            Object parseObject = JSON.parseObject((String)JSON.toJSONString((Object)xbrl2Json), boClazz);
            return parseObject;
        }
        catch (UnsupportedEncodingException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    @TLog(text="\u89e3\u6790ZIP\u5e76\u5408\u5e76\u8be6\u60c5")
    public VerifyDetailVO verifyToDetail(MultipartFile file) {
        VerifyDetailVO detailVO = new VerifyDetailVO();
        String parseFileName = file.getOriginalFilename();
        IEleVoucherParseStrategy instance = EleVoucherParseFactory.getInstance(parseFileName);
        VerifyRecordVO verifyRecord = instance.parseSign(file);
        verifyRecord.setVerifyTime(new Date());
        byte[] data = ZipUtil.getXbrlFromZip(file);
        if (null == data) {
            throw CheckFailedException.newInstance((String)"\u83b7\u53d6xbrl\u6587\u4ef6\u5931\u8d25\u3002");
        }
        Object parseObject = null;
        HashedMap map = new HashedMap();
        try {
            String xbrl = new String(data, "UTF-8");
            PreconditionUtil.checkNotTrimEmpty((String)xbrl, (String)"xbrl\u6587\u4ef6\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a\u3002");
            ElecVoucherBOEnum elecVoucherBO = instance.getElecVoucherBOEunm(file);
            String configId = elecVoucherBO.getConfigId();
            PreconditionUtil.checkNotTrimEmpty((String)configId, (String)"configId\u4e0d\u80fd\u4e3a\u7a7a\u3002");
            JSONObject xbrl2Json = VoucherFileUtil.xbrl2Json((String)xbrl, (String)configId);
            verifyRecord.setVoucherType(elecVoucherBO.ordinal());
            verifyRecord.setUniqueCode(xbrl2Json.getString("UniqueCodeOfInvoice"));
            Class<?> boClazz = elecVoucherBO.getBoClazz();
            parseObject = JSON.parseObject((String)JSON.toJSONString((Object)xbrl2Json), boClazz);
            this.resetParam(parseObject, (Map<String, Object>)map, boClazz);
        }
        catch (UnsupportedEncodingException | IllegalAccessException | IllegalArgumentException | SecurityException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        String jsonObject = JSONObject.toJSONString((Object)map);
        detailVO.setRecordVO(verifyRecord);
        detailVO.setVounchInfo(jsonObject);
        return detailVO;
    }

    private void resetParam(Object parseObject, Map<String, Object> map, Class<?> boClazz) throws IllegalAccessException {
        Field[] declaredFields = boClazz.getDeclaredFields();
        Field[] superFields = boClazz.getSuperclass().getDeclaredFields();
        for (Field field : declaredFields) {
            field.setAccessible(true);
            Class<?> fieldType = field.getType();
            if (fieldType.equals(List.class)) {
                Type genericType = field.getGenericType();
                if (!(genericType instanceof ParameterizedType)) continue;
                ArrayList<HashedMap> curEleList = new ArrayList<HashedMap>();
                List value = (List)field.get(parseObject);
                for (Object object : value) {
                    HashedMap listMap = new HashedMap();
                    for (Field listField : object.getClass().getDeclaredFields()) {
                        listField.setAccessible(true);
                        String fieldName = listField.getName();
                        if (fieldName.equals("serialVersionUID")) continue;
                        Object listvalue = listField.get(object);
                        listMap.put(fieldName, listvalue);
                    }
                    curEleList.add(listMap);
                }
                map.put(field.getName(), curEleList);
                continue;
            }
            map.put(field.getName(), field.get(parseObject));
        }
        for (Field field : superFields) {
            field.setAccessible(true);
            map.put(field.getName(), field.get(parseObject));
        }
    }

    @Override
    @TLog(text="\u89e3\u6790\u6587\u4ef6\u5e76\u5408\u5e76\u8be6\u60c5")
    public VerifyDetailVO verifyToDetail(MultipartFile file, int invType) {
        VerifyDetailVO detailVO = new VerifyDetailVO();
        String parseFileName = file.getOriginalFilename();
        IEleVoucherParseStrategy instance = EleVoucherParseFactory.getInstance(parseFileName);
        VerifyRecordVO verifyRecord = instance.parseSign(file);
        Object parseObject = null;
        try {
            ElecVoucherBOEnum elecVoucherBO = instance.getElecVoucherBOEunm(file);
            if (!elecVoucherBO.equals((Object)ElecVoucherBOEnum.values()[invType])) {
                throw new AbcIllegalArgumentException("ABC.0030", "\u4e0a\u4f20\u6587\u4ef6\u4e0e\u6240\u9009\u6587\u4ef6\u7c7b\u578b\u4e0d\u5339\u914d\u3002");
            }
            String configId = elecVoucherBO.getConfigId();
            JSONObject parseVoucher = instance.parseVoucher(file, configId);
            if (null == parseVoucher) {
                throw new AbcIllegalArgumentException("ABC.0030", "\u6587\u4ef6\u89e3\u6790\u4e3a\u7a7a\uff0c\u8bf7\u4f20\u5165\u6b63\u786e\u7684\u6587\u4ef6\u3002");
            }
            verifyRecord.setVoucherType(elecVoucherBO.ordinal());
            parseObject = this.transToBO(parseVoucher, elecVoucherBO, verifyRecord);
        }
        catch (IllegalArgumentException | SecurityException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        detailVO.setRecordVO(verifyRecord);
        detailVO.setVounchInfo(parseObject);
        return detailVO;
    }

    private Object transToBO(JSONObject parseVoucher, ElecVoucherBOEnum elecVoucherBO, VerifyRecordVO verifyRecord) {
        Object object = null;
        if (InvOrdIssuerOriginBO.class == elecVoucherBO.getBoClazz()) {
            object = this.getInvOrd(parseVoucher, elecVoucherBO, verifyRecord);
        } else if (InvSpclIssuerOriginBO.class == elecVoucherBO.getBoClazz()) {
            object = this.getInvSpc(parseVoucher, elecVoucherBO, verifyRecord);
        } else if (InvTlfIssuerOriginBO.class == elecVoucherBO.getBoClazz()) {
            object = this.getInvTlf(parseVoucher, elecVoucherBO, verifyRecord);
        } else if (AtrIssuerOriginBO.class == elecVoucherBO.getBoClazz()) {
            object = this.getAtrIssuer(parseVoucher, elecVoucherBO, verifyRecord);
        } else if (RaiIssuerOriginBO.class == elecVoucherBO.getBoClazz()) {
            object = this.getRaiIssuer(parseVoucher, elecVoucherBO, verifyRecord);
        } else if (NtrevGpmIssuerOriginBO.class == elecVoucherBO.getBoClazz()) {
            object = this.getNtrevGpm(parseVoucher, verifyRecord);
        } else if (BkerIssuerOriginBO.class == elecVoucherBO.getBoClazz()) {
            object = this.getBker(parseVoucher, elecVoucherBO, verifyRecord);
        } else if (BkrsOriginBO.class == elecVoucherBO.getBoClazz()) {
            object = this.getBkrs(parseVoucher, elecVoucherBO, verifyRecord);
        }
        return object;
    }

    private Object getInvOrd(JSONObject parseVoucher, ElecVoucherBOEnum elecVoucherBO, VerifyRecordVO verifyRecord) {
        InvOrdIssuerOriginBO bo = (InvOrdIssuerOriginBO)JSON.parseObject((String)JSON.toJSONString((Object)parseVoucher), InvOrdIssuerOriginBO.class);
        InvOrdIssuerBO parseObject = new InvOrdIssuerBO();
        BeanUtils.copyProperties((Object)bo, (Object)parseObject);
        verifyRecord.setUniqueCode(bo.getInvUniqueCode());
        ArrayList taxableItems = BlockCollectionUtil.newArrayListInstance();
        if (BlockCollectionUtil.isEmpty(bo.getTaxableItems())) {
            parseObject.setTaxableItems(taxableItems);
        } else {
            bo.getTaxableItems().forEach(ele -> {
                TaxableItemBO item = new TaxableItemBO();
                BeanUtils.copyProperties((Object)ele, (Object)item);
                taxableItems.add(item);
            });
        }
        parseObject.setTaxableItems(taxableItems);
        parseObject.setVoucherType(elecVoucherBO.ordinal());
        parseObject.setVoucherTypeDesp(elecVoucherBO.getVoucherTypeName());
        InvOrdIssuerBO object = parseObject;
        return object;
    }

    private Object getInvSpc(JSONObject parseVoucher, ElecVoucherBOEnum elecVoucherBO, VerifyRecordVO verifyRecord) {
        InvSpclIssuerOriginBO bo = (InvSpclIssuerOriginBO)JSON.parseObject((String)JSON.toJSONString((Object)parseVoucher), InvSpclIssuerOriginBO.class);
        InvOrdIssuerBO parseObject = new InvOrdIssuerBO();
        BeanUtils.copyProperties((Object)bo, (Object)parseObject);
        verifyRecord.setUniqueCode(bo.getInvUniqueCode());
        ArrayList taxableItems = BlockCollectionUtil.newArrayListInstance();
        if (BlockCollectionUtil.isEmpty(bo.getTaxableItems())) {
            parseObject.setTaxableItems(taxableItems);
        } else {
            bo.getTaxableItems().forEach(ele -> {
                TaxableItemBO item = new TaxableItemBO();
                BeanUtils.copyProperties((Object)ele, (Object)item);
                taxableItems.add(item);
            });
        }
        parseObject.setTaxableItems(taxableItems);
        parseObject.setVoucherType(elecVoucherBO.ordinal());
        parseObject.setVoucherTypeDesp(elecVoucherBO.getVoucherTypeName());
        InvOrdIssuerBO object = parseObject;
        return object;
    }

    private Object getInvTlf(JSONObject parseVoucher, ElecVoucherBOEnum elecVoucherBO, VerifyRecordVO verifyRecord) {
        InvTlfIssuerOriginBO bo = (InvTlfIssuerOriginBO)JSON.parseObject((String)JSON.toJSONString((Object)parseVoucher), InvTlfIssuerOriginBO.class);
        InvTlfIssuerBO parseObject = new InvTlfIssuerBO();
        BeanUtils.copyProperties((Object)bo, (Object)parseObject);
        verifyRecord.setUniqueCode(bo.getInvUniqueCode());
        ArrayList taxableItems = BlockCollectionUtil.newArrayListInstance();
        if (BlockCollectionUtil.isEmpty(bo.getTollFeeItems())) {
            parseObject.setTollFeeItems(taxableItems);
        } else {
            bo.getTollFeeItems().forEach(ele -> {
                TollFeeItemBO item = new TollFeeItemBO();
                BeanUtils.copyProperties((Object)ele, (Object)item);
                taxableItems.add(item);
            });
        }
        parseObject.setTollFeeItems(taxableItems);
        parseObject.setVoucherType(elecVoucherBO.ordinal());
        parseObject.setVoucherTypeDesp(elecVoucherBO.getVoucherTypeName());
        InvTlfIssuerBO object = parseObject;
        return object;
    }

    private Object getAtrIssuer(JSONObject parseVoucher, ElecVoucherBOEnum elecVoucherBO, VerifyRecordVO verifyRecord) {
        AtrIssuerOriginBO bo = (AtrIssuerOriginBO)JSON.parseObject((String)JSON.toJSONString((Object)parseVoucher), AtrIssuerOriginBO.class);
        AtrIssuerBO parseObject = new AtrIssuerBO();
        BeanUtils.copyProperties((Object)bo, (Object)parseObject);
        verifyRecord.setUniqueCode(bo.getInvUniqueCode());
        ArrayList taxableItems = BlockCollectionUtil.newArrayListInstance();
        if (BlockCollectionUtil.isEmpty(bo.getAirTickItem())) {
            parseObject.setAirTickItems(taxableItems);
        } else {
            bo.getAirTickItem().forEach(ele -> {
                AirTickItemBO item = new AirTickItemBO();
                BeanUtils.copyProperties((Object)ele, (Object)item);
                taxableItems.add(item);
            });
        }
        parseObject.setAirTickItems(taxableItems);
        parseObject.setVoucherType(elecVoucherBO.ordinal());
        parseObject.setVoucherTypeDesp(elecVoucherBO.getVoucherTypeName());
        AtrIssuerBO object = parseObject;
        return object;
    }

    private Object getNtrevGpm(JSONObject parseVoucher, VerifyRecordVO verifyRecord) {
        NtrevGpmIssuerOriginBO ntrevGpmOrignBO = (NtrevGpmIssuerOriginBO)JSON.parseObject((String)JSON.toJSONString((Object)parseVoucher), NtrevGpmIssuerOriginBO.class);
        NtrevGpmIssuerBO bo = new NtrevGpmIssuerBO();
        this.ntrevTransToBO(verifyRecord, ntrevGpmOrignBO, bo);
        NtrevGpmIssuerBO object = bo;
        return object;
    }

    private Object getRaiIssuer(JSONObject parseVoucher, ElecVoucherBOEnum elecVoucherBO, VerifyRecordVO verifyRecord) {
        RaiIssuerOriginBO bo = (RaiIssuerOriginBO)JSON.parseObject((String)JSON.toJSONString((Object)parseVoucher), RaiIssuerOriginBO.class);
        RaiIssuerBO parseObject = new RaiIssuerBO();
        BeanUtils.copyProperties((Object)bo, (Object)parseObject);
        verifyRecord.setUniqueCode(bo.getInvUniqueCode());
        parseObject.setVoucherType(elecVoucherBO.ordinal());
        parseObject.setVoucherTypeDesp(elecVoucherBO.getVoucherTypeName());
        RaiIssuerBO object = parseObject;
        return object;
    }

    private Object getBker(JSONObject parseVoucher, ElecVoucherBOEnum elecVoucherBO, VerifyRecordVO verifyRecord) {
        BkerIssuerOriginBO bo = (BkerIssuerOriginBO)JSON.parseObject((String)JSON.toJSONString((Object)parseVoucher), BkerIssuerOriginBO.class);
        BkerIssuerBO parseObject = new BkerIssuerBO();
        BeanUtils.copyProperties((Object)bo, (Object)parseObject);
        verifyRecord.setUniqueCode(bo.getInvUniqueCode());
        parseObject.setVoucherType(elecVoucherBO.ordinal());
        parseObject.setVoucherTypeDesp(elecVoucherBO.getVoucherTypeName());
        BkerIssuerBO object = parseObject;
        return object;
    }

    private Object getBkrs(JSONObject parseVoucher, ElecVoucherBOEnum elecVoucherBO, VerifyRecordVO verifyRecord) {
        BkrsOriginBO bo = (BkrsOriginBO)JSON.parseObject((String)JSON.toJSONString((Object)parseVoucher), BkrsOriginBO.class);
        BkrsBO parseObject = new BkrsBO();
        BeanUtils.copyProperties((Object)bo, (Object)parseObject);
        verifyRecord.setUniqueCode(bo.getInvUniqueCode());
        ArrayList taxableItems = BlockCollectionUtil.newArrayListInstance();
        if (BlockCollectionUtil.isEmpty(bo.getBankReconItems())) {
            parseObject.setBankReconItems(taxableItems);
        } else {
            bo.getBankReconItems().forEach(ele -> {
                BankReconItemBO item = new BankReconItemBO();
                BeanUtils.copyProperties((Object)ele, (Object)item);
                taxableItems.add(item);
            });
        }
        parseObject.setBankReconItems(taxableItems);
        parseObject.setVoucherType(elecVoucherBO.ordinal());
        parseObject.setVoucherTypeDesp(elecVoucherBO.getVoucherTypeName());
        BkrsBO object = parseObject;
        return object;
    }

    private void ntrevTransToBO(VerifyRecordVO verifyRecord, NtrevGpmIssuerOriginBO ntrevGpmOrignBO, NtrevGpmIssuerBO bo) {
        NtrevHeaderBO ntrevHeaderBO = ntrevGpmOrignBO.getHeader().get(0);
        NtrevInvDataMainBO dataMain = ntrevGpmOrignBO.getEinvData().get(0).getMain().get(0);
        List<NtrevGpmItemBO> detailBOs = ntrevGpmOrignBO.getEinvData().get(0).getDetails().get(0).getItems();
        NtrevExecAgencyPartyBO ntrevExecAgencyPartyBO = dataMain.getExecAgencyParty().get(0);
        NtrevPayerPartyBO ntrevPayerPartyBO = dataMain.getPayerParty().get(0);
        NtrevSealInfoBO exeSealInfoBO = dataMain.getExecPartSeal().get(0);
        NtrevSealInfoBO finSealInfoBO = dataMain.getFiscalPartSeal().get(0);
        NtrevMainExtBO ntrevMainExtBO = dataMain.getMainExt().get(0);
        String elesignatureTime = ntrevGpmOrignBO.getEinvSignature().get(0).getInvPartySignature().get(0).getSignatureTime();
        bo.setExeSignatureTime(elesignatureTime);
        String elesignatureValue = ntrevGpmOrignBO.getEinvSignature().get(0).getInvPartySignature().get(0).getSignatureValue();
        bo.setExeSignatureValue(elesignatureValue);
        NtrevCertificateInforBO elentrevCertificateInforBO = ntrevGpmOrignBO.getEinvSignature().get(0).getInvPartySignature().get(0).getCertificateInfo().get(0);
        bo.setExeSerialNumber(elentrevCertificateInforBO.getSerialNumber());
        bo.setExeX509issuerName(elentrevCertificateInforBO.getX509issuerName());
        NtrevSignInfoBO elentrevSignInfoBO = ntrevGpmOrignBO.getEinvSignature().get(0).getInvPartySignature().get(0).getSignInfo().get(0);
        bo.setExeReference(elentrevSignInfoBO.getReference());
        bo.setExeSignatureAlgorithm(elentrevSignInfoBO.getSignatureAlgorithm());
        bo.setExeSignatureFormat(elentrevSignInfoBO.getSignatureFormat());
        String finsignatureTime = ntrevGpmOrignBO.getEinvSignature().get(0).getSupPartySignature().get(0).getSignatureTime();
        bo.setFanSignatureTime(finsignatureTime);
        String finsignatureValue = ntrevGpmOrignBO.getEinvSignature().get(0).getSupPartySignature().get(0).getSignatureValue();
        bo.setFanSignatureValue(finsignatureValue);
        NtrevCertificateInforBO finntrevCertificateInforBO = ntrevGpmOrignBO.getEinvSignature().get(0).getSupPartySignature().get(0).getCertificateInfo().get(0);
        bo.setFanSerialNumber(finntrevCertificateInforBO.getSerialNumber());
        bo.setFanX509issuerName(finntrevCertificateInforBO.getX509issuerName());
        if (StringUtil.isNullOrTrimEmptyString((String)elesignatureTime)) {
            bo.setExeSignatureTime("");
        } else {
            bo.setExeSignatureTime(BlockDateUtil.formatDate((Date)BlockDateUtil.parseDate((String)bo.getExeSignatureTime(), (String)"yyyyMMddhhmmss"), (String)"yyyy-MM-dd"));
        }
        if (StringUtil.isNullOrTrimEmptyString((String)finsignatureTime)) {
            bo.setFanSignatureTime("");
        } else {
            bo.setFanSignatureTime(BlockDateUtil.formatDate((Date)BlockDateUtil.parseDate((String)bo.getFanSignatureTime(), (String)"yyyyMMddhhmmss"), (String)"yyyy-MM-dd"));
        }
        NtrevSignInfoBO finntrevSignInfoBO = ntrevGpmOrignBO.getEinvSignature().get(0).getSupPartySignature().get(0).getSignInfo().get(0);
        bo.setFanReference(finntrevSignInfoBO.getReference());
        bo.setFanSignatureAlgorithm(finntrevSignInfoBO.getSignatureAlgorithm());
        bo.setFanSignatureFormat(finntrevSignInfoBO.getSignatureFormat());
        BeanUtils.copyProperties((Object)ntrevHeaderBO, (Object)bo);
        BeanUtils.copyProperties((Object)dataMain, (Object)bo);
        BeanUtils.copyProperties((Object)ntrevExecAgencyPartyBO, (Object)bo);
        BeanUtils.copyProperties((Object)ntrevPayerPartyBO, (Object)bo);
        bo.setExeSealId(exeSealInfoBO.getSealId());
        bo.setExeSealName(exeSealInfoBO.getSealName());
        bo.setExeSealHash(exeSealInfoBO.getSealHash());
        bo.setFanSealId(finSealInfoBO.getSealId());
        bo.setFanSealName(finSealInfoBO.getSealName());
        bo.setFanSealHash(finSealInfoBO.getSealHash());
        BeanUtils.copyProperties((Object)ntrevMainExtBO, (Object)bo);
        if (BlockCollectionUtil.isEmpty(detailBOs)) {
            bo.setNtrevGpmItems(BlockCollectionUtil.newArrayListInstance());
        } else {
            bo.setNtrevGpmItems(detailBOs);
        }
        bo.setInvUniqueCode(ntrevHeaderBO.getEinvId());
        verifyRecord.setUniqueCode(ntrevHeaderBO.getEinvId());
    }

    @Override
    public Object parseAllelec(MultipartFile file) {
        byte[] data = ZipUtil.getXbrlFromZip(file);
        if (null == data) {
            throw CheckFailedException.newInstance((String)"\u83b7\u53d6xbrl\u6587\u4ef6\u5931\u8d25\u3002");
        }
        IEleVoucherParseStrategy instance = EleVoucherParseFactory.getInstance(file.getOriginalFilename());
        try {
            Object jsonObject = instance.getAllElec(file);
            return jsonObject;
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }
}

