/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.eepsp.service.explain.verify.strategy.impl;

import api.VoucherFileUtil;
import com.alibaba.fastjson.JSONObject;
import com.ygsoft.abc.eepsp.service.explain.common.type.ElecVoucherBOEnum;
import com.ygsoft.abc.eepsp.service.explain.verify.domain.vo.VerifyRecordVO;
import com.ygsoft.abc.eepsp.service.explain.verify.domain.vo.XbrlFileVO;
import com.ygsoft.abc.eepsp.service.explain.verify.impl.transfer.VerifyRecordTransfer;
import com.ygsoft.abc.eepsp.service.explain.verify.strategy.IEleVoucherParseStrategy;
import com.ygsoft.abc.eepsp.service.explain.verify.util.ZipUtil;
import com.ygsoft.abc.mapp.ygca.gwcw.common.config.VerifyConfig;
import com.ygsoft.abc.mapp.ygca.gwcw.common.types.YesnoEnum;
import com.ygsoft.abc.mapp.ygca.gwcw.domain.vo.VerifyResultVO;
import com.ygsoft.abc.mapp.ygca.gwcw.factory.BizSignatureServiceFactory;
import com.ygsoft.abc.mapp.ygca.gwcw.service.IBizSignatureService;
import com.ygsoft.abc.service.annotation.TLog;
import com.ygsoft.abc.service.exception.AbcIllegalArgumentException;
import com.ygsoft.abc.service.exception.CheckFailedException;
import com.ygsoft.abc.service.tool.BlockIOUtil;
import com.ygsoft.abc.service.tool.PreconditionUtil;
import com.ygsoft.ecp.service.log.EcpLogFactory;
import com.ygsoft.ecp.service.log.IEcpLog;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartFile;

@Component
public class EleVoucherParseZip
implements IEleVoucherParseStrategy {
    private static final IEcpLog LOG = EcpLogFactory.getLog(EleVoucherParseZip.class);

    @Override
    @TLog(text="\u9a8c\u7b7eZIP")
    public VerifyRecordVO parseSign(MultipartFile file) {
        byte[] zipData;
        PreconditionUtil.checkNotNull((Object)file, (String)"zip\u5305\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        VerifyRecordVO resultVO = null;
        try {
            zipData = BlockIOUtil.toByteArray((InputStream)file.getInputStream());
        }
        catch (Exception e) {
            LOG.error((Object)"\u8bfb\u53d6zip\u6587\u4ef6\u9519\u8bef\u3002", (Throwable)e);
            resultVO = new VerifyRecordVO();
            resultVO.setSuccessed(YesnoEnum.NO);
            return resultVO;
        }
        VerifyRecordVO recordVO = new VerifyRecordVO();
        VerifyResultVO verifyResultVO = null;
        VerifyConfig verifyConfig = this.getVerifyConfig();
        IBizSignatureService service = BizSignatureServiceFactory.getInstance((VerifyConfig)verifyConfig);
        try {
            verifyResultVO = service.verify(zipData, "zip");
            recordVO = VerifyRecordTransfer.getInstance().verifyResultToVerifyRecordVO(verifyResultVO);
            recordVO.setFileName(file.getOriginalFilename());
        }
        catch (Exception e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)"\u9a8c\u7b7ezip\u5931\u8d25", (Throwable)e);
            }
            recordVO.setSuccessed(YesnoEnum.NO);
        }
        recordVO.setVerifyTime(new Date());
        return recordVO;
    }

    @Override
    @TLog(text="\u89e3\u6790ZIP")
    public JSONObject parseVoucher(MultipartFile file, String configId) {
        PreconditionUtil.checkNotNull((Object)file, (String)"zip\u5305\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        byte[] data = ZipUtil.getXbrlFromZip(file);
        if (null == data) {
            throw CheckFailedException.newInstance((String)"\u83b7\u53d6xbrl\u6587\u4ef6\u5931\u8d25\u3002");
        }
        JSONObject xbrl2Json = null;
        try {
            String xbrl = new String(data, "UTF-8");
            PreconditionUtil.checkNotTrimEmpty((String)xbrl, (String)"xbrl\u6587\u4ef6\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a\u3002");
            PreconditionUtil.checkNotTrimEmpty((String)configId, (String)"configId\u4e0d\u80fd\u4e3a\u7a7a\u3002");
            xbrl2Json = VoucherFileUtil.xbrl2Json((String)xbrl, (String)configId);
        }
        catch (UnsupportedEncodingException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        return xbrl2Json;
    }

    @Override
    @TLog(text="\u89e3\u6790ZIP\u4e2d\u7684xbrl")
    public XbrlFileVO parse2XBRL(MultipartFile file, int voucherType) {
        ElecVoucherBOEnum elecVoucherBO = this.getElecVoucherBOEunm(file);
        if (!elecVoucherBO.equals((Object)ElecVoucherBOEnum.values()[voucherType])) {
            throw new AbcIllegalArgumentException("ABC.0030", "\u4e0a\u4f20\u6587\u4ef6\u4e0e\u6240\u9009\u6587\u4ef6\u7c7b\u578b\u4e0d\u5339\u914d\u3002");
        }
        String xbrl = "";
        byte[] data = ZipUtil.getXbrlFromZip(file);
        if (null == data) {
            throw CheckFailedException.newInstance((String)"\u83b7\u53d6xbrl\u6587\u4ef6\u5931\u8d25\u3002");
        }
        try {
            xbrl = new String(data, "UTF-8");
            PreconditionUtil.checkNotTrimEmpty((String)xbrl, (String)"xbrl\u6587\u4ef6\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        catch (UnsupportedEncodingException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        XbrlFileVO xbrlVO = new XbrlFileVO();
        xbrlVO.setXbrlJsonString(xbrl);
        return xbrlVO;
    }

    @Override
    public Object getAllElec(MultipartFile file) {
        return null;
    }

    @Override
    public Object getNotGwSpecialVat(MultipartFile file) {
        return null;
    }

    @Override
    public ElecVoucherBOEnum getElecVoucherBOEunm(MultipartFile file) {
        ElecVoucherBOEnum[] elecVoucherBOs;
        PreconditionUtil.checkNotNull((Object)file, (String)"zip\u5305\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        String parseFileName = file.getOriginalFilename();
        PreconditionUtil.checkNotNull((Object)parseFileName, (String)"fileName\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        for (ElecVoucherBOEnum boEnum : elecVoucherBOs = ElecVoucherBOEnum.values()) {
            String configId = boEnum.getConfigId();
            if (!StringUtils.isNotEmpty((CharSequence)configId) || parseFileName.indexOf(configId) != 0) continue;
            return boEnum;
        }
        throw CheckFailedException.newInstance((String)("\u4e0d\u652f\u6301\u7684\u51ed\u8bc1\u7c7b\u578b\u3002\u6587\u4ef6\u540d\uff1a" + parseFileName));
    }
}

