/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.eepsp.service.explain.verify.util;

import com.ygsoft.abc.mapp.ygca.gwcw.domain.vo.VerifyResultVO;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class VerifyInfoExtractUtil {
    private static final Pattern regSigner = Pattern.compile("(?<=CN=).*");
    private static final Pattern regSignerEndWithAt = Pattern.compile("(?<=CN=).*?(?=@)*");
    private static final Pattern regCaName = Pattern.compile("(?<=OU=).*?(?=,)");
    private static final Pattern regBusinessNo = Pattern.compile("(?<=@).*?(?=,)");
    private final VerifyResultVO verifyResultVO;

    private VerifyInfoExtractUtil(VerifyResultVO verifyResultVO) {
        this.verifyResultVO = verifyResultVO;
    }

    public static VerifyInfoExtractUtil on(VerifyResultVO verifyResultVO) {
        return new VerifyInfoExtractUtil(verifyResultVO);
    }

    public String getSigner() {
        String subject = this.verifyResultVO.getSignInfo().getCertInfo().getSubject();
        if (StringUtils.isEmpty((CharSequence)subject)) {
            return "";
        }
        String[] split = subject.split("=");
        if (split.length > 0) {
            return split[split.length - 1].contains("@") ? split[split.length - 1].split("@")[0] : split[split.length - 1];
        }
        return "-";
    }

    public String getCaName() {
        String issuer = this.verifyResultVO.getSignInfo().getCertInfo().getIssuer();
        if (StringUtils.isEmpty((CharSequence)issuer)) {
            return "";
        }
        return issuer;
    }

    public String getBusinessNo() {
        String subject = this.verifyResultVO.getSignInfo().getCertInfo().getSubject();
        if (StringUtils.isEmpty((CharSequence)subject)) {
            return "";
        }
        String[] split = subject.split("@");
        if (split.length > 1) {
            return split[split.length - 1];
        }
        return "-";
    }
}

