/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.eepsp.service.explain.verify.util;

import com.ygsoft.abc.eepsp.service.explain.verify.util.EepspCommonUtil;
import com.ygsoft.abc.mapp.ygca.gwcw.util.IOUtil;
import com.ygsoft.abc.service.exception.AbcServiceException;
import com.ygsoft.abc.service.exception.EmptyValueException;
import com.ygsoft.abc.service.tool.AttachUtil;
import com.ygsoft.abc.service.tool.BlockIOUtil;
import com.ygsoft.abc.service.tool.PreconditionUtil;
import com.ygsoft.commons.io.IOUtils;
import com.ygsoft.ecp.service.log.EcpLogFactory;
import com.ygsoft.ecp.service.log.IEcpLog;
import com.ygsoft.ecp.service.tool.StringUtil;
import com.ygsoft.ecp.service.tool.UuidUtil;
import com.ygsoft.ecp.service.unstructure.EntityAttachmentSummaryVO;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FileUtils;
import org.fusesource.hawtbuf.ByteArrayInputStream;
import org.springframework.web.multipart.MultipartFile;

public final class ZipUtil {
    private static final IEcpLog LOG = EcpLogFactory.getLog(ZipUtil.class);
    private static final int BUFFER_SIZE = 2048;

    private ZipUtil() {
    }

    public static List<EntityAttachmentSummaryVO> zip2Attachments(MultipartFile zip) {
        byte[] zipData;
        PreconditionUtil.checkNotNull((Object)zip, (String)"zip\u5305\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        ArrayList<EntityAttachmentSummaryVO> list = new ArrayList<EntityAttachmentSummaryVO>();
        try {
            zipData = IOUtils.toByteArray((InputStream)zip.getInputStream());
        }
        catch (IOException e) {
            LOG.error((Object)"\u8bfb\u53d6zip\u6587\u4ef6\u9519\u8bef\u3002", (Throwable)e);
            return list;
        }
        File zipFile = ZipUtil.multipartFileToFile(zip);
        EntityAttachmentSummaryVO zipAttachment = AttachUtil.toEntityAttachmentSummary((File)zipFile, (String)zip.getOriginalFilename(), (String)UuidUtil.newUUID());
        zipFile.delete();
        list.add(zipAttachment);
        ZipInputStream zin = null;
        try {
            ZipEntry entry;
            zin = new ZipInputStream((InputStream)new ByteArrayInputStream(zipData));
            while ((entry = zin.getNextEntry()) != null) {
                String entryName = entry.getName();
                ByteArrayOutputStream byteOutput = new ByteArrayOutputStream();
                IOUtil.copy((InputStream)zin, (OutputStream)byteOutput);
                byte[] data = byteOutput.toByteArray();
                byteOutput.flush();
                IOUtil.close((Closeable)byteOutput);
                EntityAttachmentSummaryVO summary = AttachUtil.toEntityAttachmentSummary((byte[])data, (String)entryName, (String)UuidUtil.newUUID());
                list.add(summary);
            }
            ArrayList<EntityAttachmentSummaryVO> arrayList = list;
            return arrayList;
        }
        catch (Exception e) {
            throw new RuntimeException("\u6587\u4ef6\u89e3\u538b\u5931\u8d25\u3002", e);
        }
        finally {
            try {
                if (zin != null) {
                    zin.closeEntry();
                }
                IOUtil.close((Closeable)zin);
            }
            catch (Exception e) {
                throw new RuntimeException("IO\u5f02\u5e38\u3002", e);
            }
        }
    }

    public static byte[] getXbrlFromZip(MultipartFile zip) {
        byte[] zipData;
        PreconditionUtil.checkNotNull((Object)zip, (String)"zip\u5305\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        try {
            zipData = IOUtils.toByteArray((InputStream)zip.getInputStream());
        }
        catch (IOException e) {
            LOG.error((Object)"\u8bfb\u53d6zip\u6587\u4ef6\u9519\u8bef\u3002", (Throwable)e);
            return null;
        }
        ZipInputStream zin = null;
        try {
            ZipEntry entry;
            zin = new ZipInputStream((InputStream)new ByteArrayInputStream(zipData));
            while ((entry = zin.getNextEntry()) != null) {
                String entryName = entry.getName();
                if (!entryName.endsWith("xml")) continue;
                ByteArrayOutputStream byteOutput = new ByteArrayOutputStream();
                IOUtil.copy((InputStream)zin, (OutputStream)byteOutput);
                byte[] data = byteOutput.toByteArray();
                byteOutput.flush();
                IOUtil.close((Closeable)byteOutput);
                byte[] byArray = data;
                return byArray;
            }
        }
        catch (Exception e) {
            throw new RuntimeException("\u6587\u4ef6\u89e3\u538b\u5931\u8d25\u3002", e);
        }
        finally {
            try {
                if (zin != null) {
                    zin.closeEntry();
                }
                IOUtil.close((Closeable)zin);
            }
            catch (Exception e) {
                throw new RuntimeException("IO\u5f02\u5e38\u3002", e);
            }
        }
        return null;
    }

    public static void toZip(String srcDir, String targetDir, String fileName) {
        ZipOutputStream zos = null;
        FileOutputStream fos = null;
        try {
            File dir = new File(targetDir);
            if (!dir.exists()) {
                FileUtils.forceMkdir((File)dir);
            }
            fos = new FileOutputStream(new File(targetDir + File.separator + fileName));
            zos = new ZipOutputStream(fos);
            File sourceFile = new File(srcDir);
            ZipUtil.compress(sourceFile, zos, sourceFile.getName());
        }
        catch (Exception e) {
            try {
                String msg = EepspCommonUtil.spliceStr("\u538b\u7f29\u6587\u4ef6\u5f02\u5e38\uff1a", e.getMessage());
                EepspCommonUtil.writeErrorLog(msg, e, LOG);
                throw new AbcServiceException("ABC.0015", msg, (Throwable)e, new Object[0]);
            }
            catch (Throwable throwable) {
                BlockIOUtil.close(zos);
                BlockIOUtil.close(fos);
                throw throwable;
            }
        }
        BlockIOUtil.close((Closeable)zos);
        BlockIOUtil.close((Closeable)fos);
    }

    public static void toZip(String srcDir, OutputStream out) {
        ZipOutputStream zos = null;
        try {
            zos = new ZipOutputStream(out);
            File sourceFile = new File(srcDir);
            ZipUtil.compress(sourceFile, zos, sourceFile.getName());
        }
        catch (Exception e) {
            try {
                String msg = EepspCommonUtil.spliceStr("\u538b\u7f29\u6587\u4ef6\u5f02\u5e38\uff1a", e.getMessage());
                EepspCommonUtil.writeErrorLog(msg, e, LOG);
                throw new AbcServiceException("ABC.0015", msg, (Throwable)e, new Object[0]);
            }
            catch (Throwable throwable) {
                BlockIOUtil.close(zos);
                throw throwable;
            }
        }
        BlockIOUtil.close((Closeable)zos);
    }

    public static void toZip(List<File> srcFiles, OutputStream out) {
        ZipOutputStream zos = null;
        try {
            zos = new ZipOutputStream(out);
            for (File srcFile : srcFiles) {
                int len;
                byte[] buf = new byte[2048];
                zos.putNextEntry(new ZipEntry(srcFile.getName()));
                FileInputStream in = new FileInputStream(srcFile);
                while ((len = in.read(buf)) != -1) {
                    zos.write(buf, 0, len);
                }
                zos.closeEntry();
                in.close();
            }
        }
        catch (Exception e) {
            try {
                String msg = EepspCommonUtil.spliceStr("\u538b\u7f29\u6587\u4ef6\u5f02\u5e38\uff1a", e.getMessage());
                EepspCommonUtil.writeErrorLog(msg, e, LOG);
                throw new AbcServiceException("ABC.0015", msg, (Throwable)e, new Object[0]);
            }
            catch (Throwable throwable) {
                BlockIOUtil.close(zos);
                throw throwable;
            }
        }
        BlockIOUtil.close((Closeable)zos);
    }

    private static void compress(File sourceFile, ZipOutputStream zos, String name) {
        try {
            byte[] buf = new byte[2048];
            if (sourceFile.isFile()) {
                int len;
                zos.putNextEntry(new ZipEntry(name));
                FileInputStream in = new FileInputStream(sourceFile);
                while ((len = in.read(buf)) != -1) {
                    zos.write(buf, 0, len);
                }
                zos.closeEntry();
                in.close();
            } else {
                File[] listFiles = sourceFile.listFiles();
                if (listFiles != null && listFiles.length != 0) {
                    for (File file : listFiles) {
                        ZipUtil.compress(file, zos, file.getName());
                    }
                }
            }
        }
        catch (Exception e) {
            String msg = EepspCommonUtil.spliceStr("\u538b\u7f29\u6587\u4ef6\u5f02\u5e38\uff1a", e.getMessage());
            EepspCommonUtil.writeErrorLog(msg, e, LOG);
            throw new AbcServiceException("ABC.0015", msg, (Throwable)e, new Object[0]);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<String> deZip(String zipFilePath, String targetPath) {
        if (StringUtil.isNullOrTrimEmptyString((String)zipFilePath)) {
            throw new EmptyValueException("ABC.0001", "\u5f85\u89e3\u538b\u6587\u4ef6\u8def\u5f84\u4e3a\u7a7a\u3002");
        }
        if (StringUtil.isNullOrTrimEmptyString((String)targetPath)) {
            throw new EmptyValueException("ABC.0001", "\u89e3\u538b\u540e\u6587\u4ef6\u5b58\u653e\u8def\u5f84\u4e3a\u7a7a\u3002");
        }
        ArrayList<String> fileNames = new ArrayList<String>();
        ZipFile zipFile = null;
        try {
            ZipEntry entry = null;
            BufferedOutputStream out = null;
            BufferedInputStream in = null;
            FileOutputStream fos = null;
            zipFile = new ZipFile(zipFilePath);
            Enumeration<? extends ZipEntry> zipEntires = zipFile.entries();
            File targetFile = new File(targetPath);
            if (!targetFile.exists()) {
                targetFile.mkdir();
            }
            while (zipEntires.hasMoreElements()) {
                try {
                    entry = zipEntires.nextElement();
                    if (entry.isDirectory()) {
                        String dirName = entry.getName();
                        dirName = dirName.substring(0, dirName.length() - 1);
                        File dirFile = new File(targetFile, dirName);
                        dirFile.mkdir();
                    } else {
                        in = new BufferedInputStream(zipFile.getInputStream(entry));
                        Integer count = null;
                        byte[] dataByte = new byte[2048];
                        String fileName = entry.getName();
                        fileNames.add(fileName);
                        fos = new FileOutputStream(new File(targetFile, fileName));
                        out = new BufferedOutputStream(fos, 2048);
                        while ((count = Integer.valueOf(in.read(dataByte, 0, 2048))) != -1) {
                            out.write(dataByte, 0, count);
                        }
                    }
                }
                catch (Exception e) {
                    try {
                        String msg = EepspCommonUtil.spliceStr("\u6587\u4ef6\u89e3\u538b\u5f02\u5e38\uff1a", e.getMessage());
                        EepspCommonUtil.writeErrorLog(msg, e, LOG);
                        throw new AbcServiceException("ABC.0015", msg, (Throwable)e, new Object[0]);
                    }
                    catch (Throwable throwable) {
                        BlockIOUtil.close(out);
                        BlockIOUtil.close(fos);
                        BlockIOUtil.close(in);
                        throw throwable;
                    }
                }
                BlockIOUtil.close(out);
                BlockIOUtil.close(fos);
                BlockIOUtil.close((Closeable)in);
            }
        }
        catch (Exception e) {
            try {
                String msg = EepspCommonUtil.spliceStr("\u6587\u4ef6\u89e3\u538b\u5f02\u5e38\uff1a", e.getMessage());
                EepspCommonUtil.writeErrorLog(msg, e, LOG);
                throw new AbcServiceException("ABC.0015", msg, (Throwable)e, new Object[0]);
            }
            catch (Throwable throwable) {
                BlockIOUtil.close(zipFile);
                throw throwable;
            }
        }
        BlockIOUtil.close((Closeable)zipFile);
        return fileNames;
    }

    private static File multipartFileToFile(MultipartFile file) {
        try {
            if (file != null && file.getSize() > 0L) {
                InputStream ins = null;
                ins = file.getInputStream();
                File toFile = new File(file.getOriginalFilename());
                ZipUtil.inputStreamToFile(ins, toFile);
                ins.close();
                return toFile;
            }
            return null;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static void inputStreamToFile(InputStream ins, File file) {
        try {
            int bytesRead;
            FileOutputStream os = new FileOutputStream(file);
            byte[] buffer = new byte[8192];
            while ((bytesRead = ins.read(buffer, 0, 8192)) != -1) {
                ((OutputStream)os).write(buffer, 0, bytesRead);
            }
            ((OutputStream)os).close();
            ins.close();
        }
        catch (Exception e) {
            EepspCommonUtil.writeErrorLog("inputstream to file error", e, LOG);
        }
    }
}

