/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.eepsp.service.explain.voucher.impl.service;

import api.VoucherFileUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.XmlUtil;
import cn.hutool.json.JSON;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.bosssoft.tool.util.ZipUtil;
import com.hnxc.soft.api.HNVoucherFileUtil;
import com.ygsoft.abc.eepsp.service.explain.common.bo.BaseResponseBO;
import com.ygsoft.abc.eepsp.service.explain.common.type.ElecVoucherBOEnum;
import com.ygsoft.abc.eepsp.service.explain.voucher.service.IVoucherBillParseService;
import com.ygsoft.abc.service.tool.BlockIOUtil;
import com.ygsoft.commons.io.FilenameUtils;
import com.ygsoft.ecp.service.log.EcpLogFactory;
import com.ygsoft.ecp.service.log.IEcpLog;
import com.ygsoft.ecp.service.tool.StringUtil;
import com.ygsoft.ecp.service.tool.UuidUtil;
import com.zhejiang.BillExtractor;
import entryevoucher.tools.Tools;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.w3c.dom.Document;

@Service
public class VoucherBillParseService
implements IVoucherBillParseService {
    private static final IEcpLog LOG = EcpLogFactory.getLog(VoucherBillParseService.class);

    @Override
    public BaseResponseBO parseFiscalBills(MultipartFile file) {
        try {
            BaseResponseBO response = this.checkFile(file, Arrays.asList(".pdf", ".ofd"));
            byte[] xmlBytes = VoucherBillParseService.mainXml(file.getBytes());
            if (xmlBytes == null || xmlBytes.length == 0) {
                xmlBytes = BillExtractor.pdfToXml((byte[])file.getBytes());
            }
            String val = new String(xmlBytes);
            JSONObject jsonObject = JSONUtil.parseFromXml((String)val);
            response.setData(jsonObject);
            return response;
        }
        catch (Throwable e) {
            String msg = String.format("\u8d22\u653f\u7968\u636e\u89e3\u6790\u5f02\u5e38\uff1a%s", e.getMessage());
            LOG.error((Object)msg, e);
            return BaseResponseBO.error(msg);
        }
    }

    public static byte[] mainXml(byte[] pdfBytes) throws IOException {
        PDDocument doc = PDDocument.load((InputStream)new ByteArrayInputStream(pdfBytes));
        String hidexml = doc.getDocumentInformation().getCustomMetadataValue("hidexml");
        doc.close();
        if (hidexml == null || hidexml.isEmpty()) {
            return new byte[0];
        }
        return ZipUtil.uncompress((String)hidexml);
    }

    @Override
    public BaseResponseBO json2Xbrl(MultipartFile multipartFile, String configId) {
        BaseResponseBO response;
        try {
            response = this.checkFile(multipartFile, Arrays.asList(".json"));
            if (response.isError()) {
                return response;
            }
            ElecVoucherBOEnum[] elecVoucherBOs = ElecVoucherBOEnum.values();
            String fileName = FilenameUtils.getName((String)multipartFile.getOriginalFilename());
            String effectiveConfigId = configId;
            if (StringUtil.isNullOrTrimEmptyString((String)effectiveConfigId) && StringUtil.isNullOrTrimEmptyString((String)(effectiveConfigId = (String)Arrays.stream(elecVoucherBOs).filter(boEnum -> fileName.contains(boEnum.getConfigId())).findFirst().map(ElecVoucherBOEnum::getConfigId).orElse(null)))) {
                return BaseResponseBO.error("\u5f85\u89e3\u6790\u6587\u4ef6\u65e0\u6cd5\u63d0\u53d6\u7968\u636e\u7c7b\u578b\u7f16\u53f7\u3002");
            }
            String xbrlString = this.fetchXmlStringFromMultipartFile(multipartFile, fileName, effectiveConfigId);
            response.setData(xbrlString);
        }
        catch (Exception e) {
            String msg = String.format("\u7968\u636e\u89e3\u6790\u5f02\u5e38\uff1a%s", e.getMessage());
            LOG.error((Object)msg, (Throwable)e);
            response = BaseResponseBO.error(msg);
        }
        return response;
    }

    private String fetchXmlStringFromMultipartFile(MultipartFile multipartFile, String fileName, String configId) throws IOException, Exception {
        File file = FileUtil.file((String)(BlockIOUtil.getTempPath() + File.separator + UuidUtil.newUUID() + fileName));
        FileUtil.writeBytes((byte[])multipartFile.getBytes(), (File)file);
        JSON json = JSONUtil.readJSON((File)file, (Charset)Charset.forName("UTF-8"));
        String xbrlString = VoucherFileUtil.json2Xbrl((String)json.toString(), (String)configId);
        return xbrlString;
    }

    @Override
    public BaseResponseBO xbrl2Json(MultipartFile multipartFile, String configId) {
        BaseResponseBO response;
        try {
            response = this.checkFile(multipartFile, Arrays.asList(".xml"));
            if (response.isError()) {
                return response;
            }
            ElecVoucherBOEnum[] elecVoucherBOs = ElecVoucherBOEnum.values();
            String fileName = FilenameUtils.getName((String)multipartFile.getOriginalFilename());
            String effectiveConfigId = configId;
            if (StringUtil.isNullOrTrimEmptyString((String)configId)) {
                effectiveConfigId = null;
                for (ElecVoucherBOEnum boEnum : elecVoucherBOs) {
                    if (fileName.indexOf(boEnum.getConfigId()) == -1) continue;
                    effectiveConfigId = boEnum.getConfigId();
                    break;
                }
                if (StringUtil.isNullOrTrimEmptyString((String)effectiveConfigId)) {
                    return BaseResponseBO.error("\u5f85\u89e3\u6790\u6587\u4ef6\u65e0\u6cd5\u63d0\u53d6\u7968\u636e\u7c7b\u578b\u7f16\u53f7\u3002");
                }
            }
            com.alibaba.fastjson.JSONObject json = this.fetchJsonStringFromMultipartFile(multipartFile, fileName, effectiveConfigId);
            response.setData(json);
        }
        catch (Throwable e) {
            String msg = String.format("\u7968\u636e\u89e3\u6790\u5f02\u5e38\uff1a%s", e.getMessage());
            LOG.error((Object)msg, e);
            response = BaseResponseBO.error(msg);
        }
        return response;
    }

    @Override
    public BaseResponseBO parseEntryEVoucher(MultipartFile multipartFile) {
        LOG.info((Object)"\u89e3\u6790\u56fd\u5e93\u96c6\u4e2d\u652f\u4ed8\u7535\u5b50\u51ed\u8bc1");
        try {
            BaseResponseBO response = this.checkFile(multipartFile, Arrays.asList(".pdf"));
            byte[] fileBytes = multipartFile.getBytes();
            byte[] xmlBytes = Tools.extractAttachment((byte[])fileBytes, (String)"pdf");
            String val = new String(xmlBytes);
            JSONObject jsonObject = JSONUtil.parseFromXml((String)val);
            response.setData(jsonObject);
            return response;
        }
        catch (Exception e) {
            String msg = String.format("\u89e3\u6790\u56fd\u5e93\u96c6\u4e2d\u652f\u4ed8\u7535\u5b50\u51ed\u8bc1\u5f02\u5e38\uff1a%s", e.getMessage());
            LOG.error((Object)msg, (Throwable)e);
            return BaseResponseBO.error(msg);
        }
    }

    private com.alibaba.fastjson.JSONObject fetchJsonStringFromMultipartFile(MultipartFile multipartFile, String fileName, String configId) throws IOException, Exception {
        Document document = XmlUtil.readXML((InputStream)multipartFile.getInputStream());
        String xbrlXml = XmlUtil.toStr((Document)document, (String)"utf-8", (boolean)false);
        com.alibaba.fastjson.JSONObject jsonObject = VoucherFileUtil.xbrl2Json((String)xbrlXml, (String)configId);
        return jsonObject;
    }

    private BaseResponseBO checkFile(MultipartFile file, List<String> suffixs) throws IOException {
        String suffix;
        String fileName;
        BaseResponseBO response = file == null || file.getBytes() == null ? BaseResponseBO.error("\u5f85\u89e3\u6790\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a\u4e14bytes\u4e0d\u80fd\u4e3a\u7a7a\u3002") : (StringUtil.isNullOrTrimEmptyString((String)(fileName = file.getOriginalFilename())) ? BaseResponseBO.error("\u5f85\u89e3\u6790\u6587\u4ef6originalFilename\u4e0d\u80fd\u4e3a\u7a7a\u3002") : (!fileName.contains(".") ? BaseResponseBO.error("\u5f85\u89e3\u6790\u6587\u4ef6\u540d\u79f0\u683c\u5f0f\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u3002") : (!suffixs.contains(suffix = fileName.substring(fileName.lastIndexOf("."))) ? BaseResponseBO.error(String.format("\u6587\u4ef6\u683c\u5f0f\u6709\u8bef\uff0c\u8bf7\u68c0\u67e5\u3002\u4ec5\u5141\u8bb8%s\u6587\u4ef6\u3002", String.join((CharSequence)",", suffixs))) : BaseResponseBO.success("\u5f85\u89e3\u6790\u6587\u4ef6\u6821\u9a8c\u6210\u529f\u3002"))));
        return response;
    }

    @Override
    public BaseResponseBO parseHnFiscalBills(MultipartFile file) {
        try {
            BaseResponseBO response = this.checkFile(file, Arrays.asList(".pdf"));
            String originalFilename = file.getOriginalFilename().substring(0, 6);
            String xmlContent = HNVoucherFileUtil.xtractXMLFromPDF((FileInputStream)((FileInputStream)file.getInputStream()), (String)originalFilename);
            JSONObject obj = JSONUtil.parseFromXml((String)xmlContent);
            response.setData(obj);
            return response;
        }
        catch (Throwable e) {
            String msg = String.format("\u8d22\u653f\u7968\u636e\u89e3\u6790\u5f02\u5e38\uff1a%s", e.getMessage());
            LOG.error((Object)msg, e);
            return BaseResponseBO.error(msg);
        }
    }
}

